/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnectors;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.scope.ScopedSession;
import org.cipango.server.transaction.Transaction;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.CSeq;
import org.cipango.sip.LazyParsingException;
import org.cipango.sip.ParameterableImpl;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipGenerator;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.Via;
import org.cipango.util.ContactAddress;
import org.cipango.util.ListIteratorProxy;
import org.cipango.util.ReadOnlyAddress;
import org.cipango.util.ReadOnlyParameterable;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SipMessage
implements SipServletMessage,
Cloneable {
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    protected String _characterEncoding;
    protected SipFields _fields = new SipFields();
    private byte[] _content;
    private SipConnection _connection;
    private int _initialTransport;
    private InetAddress _initialRemoteAddr;
    private int _initialRemotePort = -1;
    protected CallSession _callSession;
    private Transaction _tx;
    protected Session _session;
    private boolean _committed = false;
    private boolean _handled = false;
    private Attributes _attributes;
    private SipServletMessage.HeaderForm _headerForm = SipServletMessage.HeaderForm.DEFAULT;
    private UserIdentity _userIdentity;

    public void addAcceptLanguage(Locale locale) {
        this.addHeader("Accept-Language", locale.toString().replace('_', '-'));
    }

    public void addAddressHeader(String name, Address address, boolean first) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (hi.getType() != 2 && hi.getOrdinal() != -1) {
            throw new IllegalArgumentException("Header: " + name + " is not of address type");
        }
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (address == null || name == null) {
            throw new NullPointerException("name or address is null");
        }
        this._fields.addAddress(buffer, address, first);
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (value == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        this._fields.addString(buffer, value);
    }

    public Locale getAcceptLanguage() {
        ListIterator<String> it = this.getFields().getValues((Buffer)SipHeaders.ACCEPT_LANGUAGE_BUFFER);
        if (!it.hasNext()) {
            return Locale.getDefault();
        }
        List acceptLanguage = SipFields.qualityList(it);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int i = 0;
        int size = acceptLanguage.size();
        if (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters((String)language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Iterator<Locale> getAcceptLanguages() {
        ListIterator<String> it = this.getFields().getValues((Buffer)SipHeaders.ACCEPT_LANGUAGE_BUFFER);
        if (!it.hasNext()) {
            return __defaultLocale.iterator();
        }
        List acceptLanguage = SipFields.qualityList(it);
        if (acceptLanguage.size() == 0) {
            return __defaultLocale.iterator();
        }
        Object langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters((String)language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, (int)size);
            langs = LazyList.add((Object)langs, (Object)new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return __defaultLocale.iterator();
        }
        List l = LazyList.getList(langs);
        return l.iterator();
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        Address address;
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (hi.getType() != 2 && hi.getOrdinal() != -1) {
            throw new ServletParseException("Header: " + name + " is not of address type");
        }
        try {
            address = this._fields.getAddress(buffer);
        }
        catch (LazyParsingException e) {
            throw new ServletParseException((Throwable)e);
        }
        if (buffer == SipHeaders.CONTACT_BUFFER && this.isSystemHeader(hi) && !this.isCommitted() && address != null) {
            return new ContactAddress(address);
        }
        if ((this.isSystemHeader(hi) || this.isCommitted()) && address != null) {
            return new ReadOnlyAddress(address);
        }
        return address;
    }

    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (hi.getType() != 2 && hi.getOrdinal() != -1) {
            throw new ServletParseException("Header: " + name + " is not of address type");
        }
        ListIterator<Address> it = this._fields.getAddressValues(buffer);
        try {
            while (it.hasNext()) {
                it.next();
            }
            while (it.hasPrevious()) {
                it.previous();
            }
        }
        catch (LazyParsingException e) {
            throw new ServletParseException((Throwable)e);
        }
        if (this.isSystemHeader(hi) || this.isCommitted()) {
            return new ListIteratorProxy<Address>(it){

                @Override
                public Address next() {
                    return new ReadOnlyAddress((Address)super.next());
                }

                @Override
                public Address previous() {
                    return new ReadOnlyAddress((Address)super.previous());
                }
            };
        }
        return it;
    }

    public SipApplicationSession getApplicationSession() {
        return this._session.getApplicationSession();
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        return this.getApplicationSession();
    }

    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.getAttribute(name);
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public String getCallId() {
        return this._fields.getString((Buffer)SipHeaders.CALL_ID_BUFFER);
    }

    public String getCharacterEncoding() {
        int i1;
        int i0;
        if (this._characterEncoding != null) {
            return this._characterEncoding;
        }
        String contentType = this.getContentType();
        if (contentType != null && (i0 = contentType.indexOf(59)) > 0 && (i1 = contentType.indexOf("charset=", i0 + 1)) >= 0) {
            int i8 = i1 + 8;
            int i2 = contentType.indexOf(59, i8);
            this._characterEncoding = i2 > 0 ? QuotedStringTokenizer.unquote((String)contentType.substring(i8, i2)) : QuotedStringTokenizer.unquote((String)contentType.substring(i8));
        }
        return this._characterEncoding;
    }

    public Object getContent() throws UnsupportedEncodingException {
        String contentType = this.getContentType();
        if (this._content != null && contentType != null && (StringUtil.startsWithIgnoreCase((String)contentType, (String)"text") || contentType.equalsIgnoreCase("application/sdp"))) {
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            return new String(this._content, charset);
        }
        return this._content;
    }

    public Locale getContentLanguage() {
        String s = this.getHeader("Content-Language");
        if (s == null) {
            return null;
        }
        return new Locale(s);
    }

    public int getContentLength() {
        int length = (int)this._fields.getLong((Buffer)SipHeaders.CONTENT_LENGTH_BUFFER);
        if (length == -1) {
            if (this._content == null) {
                return 0;
            }
            return this._content.length;
        }
        return length;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public int getExpires() {
        return (int)this._fields.getLong((Buffer)SipHeaders.EXPIRES_BUFFER);
    }

    public Address getFrom() {
        return new ReadOnlyAddress(this._fields.getAddress((Buffer)SipHeaders.FROM_BUFFER));
    }

    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        return this._fields.getString(name);
    }

    public ListIterator<String> getHeaders(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        return this._fields.getValues(name);
    }

    public Iterator<String> getHeaderNames() {
        return this._fields.getNames();
    }

    public String getLocalAddr() {
        return this._connection != null ? this._connection.getLocalAddress().getHostAddress() : null;
    }

    public int getLocalPort() {
        return this._connection != null ? this._connection.getLocalPort() : -1;
    }

    public String getProtocol() {
        return "SIP/2.0";
    }

    public byte[] getRawContent() {
        return this._content;
    }

    public String getRemoteAddr() {
        return this._connection != null ? this._connection.getRemoteAddress().getHostAddress() : null;
    }

    public int getRemotePort() {
        return this._connection != null ? Integer.valueOf(this._connection.getRemotePort()) : null;
    }

    public String getRemoteUser() {
        if (this._userIdentity != null) {
            return this._userIdentity.getUserPrincipal().getName();
        }
        return null;
    }

    public SipSession getSession() {
        return new ScopedSession(this._session);
    }

    public SipSession getSession(boolean create) {
        return this.getSession();
    }

    public Address getTo() {
        return new ReadOnlyAddress(this._fields.getAddress((Buffer)SipHeaders.TO_BUFFER));
    }

    public String getTransport() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getConnector().getTransport();
    }

    public Principal getUserPrincipal() {
        if (this._userIdentity != null) {
            return this._userIdentity.getUserPrincipal();
        }
        return null;
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        if (this._userIdentity != null) {
            return this._userIdentity.isUserInRole(role, (UserIdentity.Scope)this.getHandler());
        }
        return false;
    }

    public void removeHeader(String name) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        this._fields.remove(buffer);
    }

    public void setAcceptLanguage(Locale locale) {
        this.setHeader("Accept-Language", locale.toString().replace('_', '-'));
    }

    public void setAddressHeader(String name, Address addr) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        this._fields.setAddress(buffer, addr);
    }

    public void setAttribute(String name, Object value) {
        if (value == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(name, value);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        "".getBytes(encoding);
        this._characterEncoding = encoding;
    }

    public void setContent(Object o, String type) throws UnsupportedEncodingException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Is committed");
        }
        if (o == null) {
            this._content = null;
            this.setContentLength(0);
            this.setContentType(type);
        } else if (o instanceof byte[]) {
            this._content = (byte[])o;
            this.setContentLength(this._content.length);
            this.setContentType(type);
        } else if (o instanceof String) {
            String s = (String)o;
            this.setContentType(type);
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            this._content = s.getBytes(charset);
            this.setContentLength(this._content.length);
        } else {
            throw new IllegalArgumentException("Unsupported object type");
        }
    }

    public void setContentLanguage(Locale locale) {
        if (locale == null) {
            this.getFields().remove((Buffer)SipHeaders.CONTENT_LANGUAGE_BUFFER);
        } else {
            this.getFields().setString((Buffer)SipHeaders.CONTENT_LANGUAGE_BUFFER, locale.toString().replace('_', '-'));
            if (this._characterEncoding == null) {
                this._characterEncoding = this._session.appSession().getContext().getLocaleEncoding(locale);
            }
        }
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        this.setHeader("Content-Length", Integer.toString(length));
    }

    public void setContentType(String contentType) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        if (contentType == null) {
            this.getFields().remove((Buffer)SipHeaders.CONTENT_TYPE_BUFFER);
        } else {
            int i1;
            int i0 = contentType.indexOf(59);
            if (i0 > 0 && (i1 = contentType.indexOf("charset=", i0 + 1)) >= 0) {
                int i8 = i1 + 8;
                int i2 = contentType.indexOf(59, i8);
                this._characterEncoding = i2 > 0 ? QuotedStringTokenizer.unquote((String)contentType.substring(i8, i2)) : QuotedStringTokenizer.unquote((String)contentType.substring(i8));
            }
            this.getFields().setString((Buffer)SipHeaders.CONTENT_TYPE_BUFFER, contentType);
        }
    }

    public void setExpires(int seconds) {
        if (seconds < 0) {
            this.removeHeader("Expires");
        } else {
            this.setHeader("Expires", Long.toString(seconds));
        }
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        this.getFields().setString(buffer, value);
    }

    public void addParameterableHeader(String name, Parameterable value, boolean first) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (hi.getType() != 1 && hi.getOrdinal() != -1) {
            throw new IllegalArgumentException("Header " + name + " is not of parameterable type");
        }
        this.getFields().addParameterable(buffer, (Parameterable)((ParameterableImpl)value), first);
    }

    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (hi.getType() != 1 && hi.getType() != 2 && hi.getOrdinal() != -1) {
            throw new ServletParseException("Header: " + name + " is not of parameterable type");
        }
        Parameterable p = this.getFields().getParameterable(buffer);
        if ((this.isSystemHeader(hi) || this.isCommitted()) && p != null) {
            return new ReadOnlyParameterable(p);
        }
        return p;
    }

    public ListIterator<? extends Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (hi.getType() != 1 && hi.getType() != 2 && hi.getOrdinal() != -1) {
            throw new ServletParseException("Header: " + name + " is not of parametrable type");
        }
        ListIterator<Parameterable> it = this.getFields().getParameterableValues(buffer);
        if (this.isSystemHeader(hi) || this.isCommitted()) {
            return new ListIteratorProxy<Parameterable>(it){

                @Override
                public Parameterable next() {
                    return new ReadOnlyParameterable((Parameterable)super.next());
                }

                @Override
                public Parameterable previous() {
                    return new ReadOnlyParameterable((Parameterable)super.previous());
                }
            };
        }
        return it;
    }

    public void setParameterableHeader(String name, Parameterable value) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        Buffer buffer = SipHeaders.CACHE.lookup(name);
        SipHeaders.HeaderInfo hi = SipHeaders.getType(buffer);
        if (this.isSystemHeader(hi)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (hi.getType() != 1 && hi.getOrdinal() != -1) {
            throw new IllegalArgumentException("Header " + name + " is not of parameterable type");
        }
        this.getFields().setParameterable(buffer, (Parameterable)((ParameterableImpl)value));
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return this._headerForm;
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        if (form == null) {
            throw new NullPointerException("Null form");
        }
        this._headerForm = form;
    }

    public String getInitialRemoteAddr() {
        if (this._initialRemoteAddr == null) {
            return null;
        }
        return this._initialRemoteAddr.getHostAddress();
    }

    public int getInitialRemotePort() {
        return this._initialRemotePort;
    }

    public String getInitialTransport() {
        return SipConnectors.getName(this._initialTransport);
    }

    protected abstract boolean canSetContact();

    public void setConnection(SipConnection connection) {
        this._connection = connection;
    }

    public SipConnection getConnection() {
        return this._connection;
    }

    public Address from() {
        return this._fields.getAddress((Buffer)SipHeaders.FROM_BUFFER);
    }

    public Address to() {
        return this._fields.getAddress((Buffer)SipHeaders.TO_BUFFER);
    }

    public Object clone() {
        try {
            SipMessage clone = (SipMessage)super.clone();
            clone._fields = this._fields.clone();
            clone._committed = false;
            clone._tx = null;
            clone._attributes = null;
            clone._connection = null;
            return clone;
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException("!cloneable");
        }
    }

    public boolean isAck() {
        return "ACK".equalsIgnoreCase(this.getMethod());
    }

    public boolean isBye() {
        return "BYE".equalsIgnoreCase(this.getMethod());
    }

    public boolean isCancel() {
        return "CANCEL".equalsIgnoreCase(this.getMethod());
    }

    public boolean isInvite() {
        return "INVITE".equalsIgnoreCase(this.getMethod());
    }

    public boolean isNotify() {
        return "NOTIFY".equalsIgnoreCase(this.getMethod());
    }

    public boolean isPrack() {
        return "PRACK".equalsIgnoreCase(this.getMethod());
    }

    public boolean isRefer() {
        return "REFER".equalsIgnoreCase(this.getMethod());
    }

    public boolean isRegister() {
        return "REGISTER".equalsIgnoreCase(this.getMethod());
    }

    public boolean isSubscribe() {
        return "SUBSCRIBE".equalsIgnoreCase(this.getMethod());
    }

    public boolean isOptions() {
        return "OPTIONS".equalsIgnoreCase(this.getMethod());
    }

    public boolean isUpdate() {
        return "UPDATE".equalsIgnoreCase(this.getMethod());
    }

    protected boolean isSystemHeader(String name) {
        BufferCache.CachedBuffer buffer = SipHeaders.CACHE.get(name);
        if (buffer == null) {
            return false;
        }
        SipHeaders.HeaderInfo type = SipHeaders.__types[buffer.getOrdinal()];
        return type.isSystem() || buffer.getOrdinal() == 13 && !this.canSetContact();
    }

    protected boolean isSystemHeader(SipHeaders.HeaderInfo type) {
        return type.isSystem() || type.getOrdinal() == 13 && !this.canSetContact();
    }

    public abstract boolean isRequest();

    public abstract boolean needsContact();

    public CSeq getCSeq() {
        try {
            return this._fields.getCSeq();
        }
        catch (ServletParseException e) {
            return null;
        }
    }

    public String getDialogId() {
        return this.getDialogId(true);
    }

    public String getDialogId(boolean fromFirst) {
        String fromTag = this.getFrom().getParameter("tag");
        String toTag = this.getTo().getParameter("tag");
        if (fromFirst) {
            return this.getCallId() + "|" + (fromTag == null ? "?" : fromTag) + "|" + (toTag == null ? "?" : toTag);
        }
        return this.getCallId() + "|" + (toTag == null ? "?" : toTag) + "|" + (fromTag == null ? "?" : fromTag);
    }

    public Via getTopVia() {
        return this._fields.getVia();
    }

    public SipFields getFields() {
        return this._fields;
    }

    public void setCallSession(CallSession callSession) {
        this._callSession = callSession;
    }

    public CallSession getCallSession() {
        if (this._callSession != null) {
            return this._callSession;
        }
        if (this._session != null) {
            return this._session.getCallSession();
        }
        return null;
    }

    public void setCommitted(boolean b) {
        this._committed = b;
    }

    public void setRawContent(byte[] content) {
        this._content = content;
    }

    public void setSession(Session session) {
        this._session = session;
    }

    public void setTransaction(Transaction tx) {
        this._tx = tx;
    }

    public void setToTag(String tag) {
        Address to = this._fields.getAddress((Buffer)SipHeaders.TO_BUFFER);
        to.setParameter("tag", tag);
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    public Session session() {
        return this._session;
    }

    public AppSession appSession() {
        return this._session.appSession();
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public abstract String getRequestLine();

    public SipServletHolder getHandler() {
        Object holder = this.getAttribute(SipServletHolder.class.getName());
        if (holder != null && holder instanceof SipServletHolder) {
            return (SipServletHolder)((Object)holder);
        }
        if (this._session != null) {
            return this._session.getHandler();
        }
        return null;
    }

    public void setHandler(SipServletHolder holder) {
        if (holder == null) {
            this.removeAttribute(SipServletHolder.class.getName());
        } else {
            this.setAttribute(SipServletHolder.class.getName(), (Object)holder);
        }
    }

    public String toString() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(64000);
        new SipGenerator().generate((Buffer)buffer, this);
        return buffer.toString();
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        this._userIdentity = userIdentity;
    }
}

