/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

public abstract class SipConnectors {
    public static final String UDP = "UDP";
    public static final String TCP = "TCP";
    public static final String TLS = "TLS";
    public static final String WS = "WS";
    public static final String WSS = "WSS";
    public static final int UDP_ORDINAL = 1;
    public static final int TCP_ORDINAL = 2;
    public static final int TLS_ORDINAL = 3;
    public static final int WS_ORDINAL = 4;
    public static final int WSS_ORDINAL = 5;

    private SipConnectors() {
    }

    public static String getName(int ordinal) {
        switch (ordinal) {
            case 1: {
                return UDP;
            }
            case 2: {
                return TCP;
            }
            case 3: {
                return TLS;
            }
            case 4: {
                return WS;
            }
            case 5: {
                return WSS;
            }
        }
        return null;
    }

    public static int getOrdinal(String name) {
        if (UDP.equalsIgnoreCase(name)) {
            return 1;
        }
        if (TCP.equalsIgnoreCase(name)) {
            return 2;
        }
        if (TLS.equalsIgnoreCase(name)) {
            return 3;
        }
        if (WS.equalsIgnoreCase(name)) {
            return 4;
        }
        if (WSS.equalsIgnoreCase(name)) {
            return 5;
        }
        return -1;
    }

    public static boolean isReliable(int ordinal) {
        switch (ordinal) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown connector: " + ordinal);
    }

    public static int getDefaultPort(int ordinal) {
        switch (ordinal) {
            case 1: {
                return 5060;
            }
            case 2: {
                return 5060;
            }
            case 3: {
                return 5061;
            }
            case 4: {
                return 80;
            }
            case 5: {
                return 443;
            }
        }
        throw new IllegalArgumentException("Unknown connector: " + ordinal);
    }
}

