/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import org.cipango.log.event.Events;
import org.cipango.server.ConnectorManager;
import org.cipango.server.SipConnector;
import org.cipango.server.SipHandler;
import org.cipango.server.SipRequest;
import org.cipango.server.ar.ApplicationRouterLoader;
import org.cipango.server.ar.RouterInfoUtil;
import org.cipango.server.handler.SipContextHandlerCollection;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.TransactionManager;
import org.cipango.sip.SipURIImpl;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class Server
extends org.eclipse.jetty.server.Server
implements SipHandler {
    private static final Logger LOG = Log.getLogger(Server.class);
    private static final String __sipVersion = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : System.getProperty("cipango.version", "2.x.y-SNAPSHOT");
    private ThreadPool _sipThreadPool;
    private ConnectorManager _connectorManager = new ConnectorManager();
    private TransactionManager _transactionManager = new TransactionManager();
    private SessionManager _sessionManager;
    private SipApplicationRouter _applicationRouter;
    private final AtomicLong _statsStartedAt = new AtomicLong(System.currentTimeMillis());

    public Server() {
        this.setConnectorManager(this._connectorManager);
        this.setTransactionManager(this._transactionManager);
    }

    protected void doStart() throws Exception {
        LOG.info("cipango-" + __sipVersion, new Object[0]);
        MultiException mex = new MultiException();
        if (this._sipThreadPool == null) {
            this.setSipThreadPool((ThreadPool)new QueuedThreadPool());
        }
        if (this._sessionManager == null) {
            this.setSessionManager(new SessionManager());
        }
        try {
            super.doStart();
        }
        catch (Throwable t) {
            mex.add(t);
        }
        if (this._applicationRouter == null) {
            this.setApplicationRouter(ApplicationRouterLoader.loadApplicationRouter());
        }
        try {
            this._applicationRouter.init();
            ArrayList<String> appNames = new ArrayList<String>();
            SipAppContext[] contexts = ((SipContextHandlerCollection)this.getHandler()).getSipContexts();
            if (contexts != null) {
                for (SipAppContext context : contexts) {
                    if (!context.hasSipServlets() || !context.isAvailable()) continue;
                    appNames.add(context.getName());
                }
            }
            this._applicationRouter.applicationDeployed(appNames);
            this._sessionManager.start();
            this._connectorManager.start();
            if (contexts != null) {
                for (SipAppContext context : contexts) {
                    context.serverStarted();
                }
            }
        }
        catch (Throwable t) {
            mex.add(t);
        }
        mex.ifExceptionThrow();
        Events.fire(0, "Cipango " + __sipVersion + " started");
    }

    protected void doStop() throws Exception {
        Events.fire(1, "Stopping Cipango " + __sipVersion);
        MultiException mex = new MultiException();
        try {
            this._applicationRouter.destroy();
            this._connectorManager.stop();
            this._sessionManager.stop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    public void setApplicationRouter(SipApplicationRouter applicationRouter) {
        this.getContainer().update((Object)this, (Object)this._applicationRouter, (Object)applicationRouter, "applicationRouter");
        this._applicationRouter = applicationRouter;
    }

    public SipApplicationRouter getApplicationRouter() {
        return this._applicationRouter;
    }

    public void applicationStarted(SipAppContext context) {
        if (this.isStarted()) {
            this._applicationRouter.applicationDeployed(Collections.singletonList(context.getName()));
            context.serverStarted();
        }
    }

    public void applicationStopped(SipAppContext context) {
        if (this.isStarted()) {
            this._applicationRouter.applicationUndeployed(Collections.singletonList(context.getName()));
        }
    }

    public void customizeRequest(SipRequest request) throws IOException {
        if (!request.isInitial()) {
            return;
        }
        SipApplicationRouterInfo routerInfo = this._applicationRouter.getNextApplication((SipServletRequest)request, request.getRegion(), request.getRoutingDirective(), null, request.getStateInfo());
        if (routerInfo != null && routerInfo.getNextApplicationName() != null) {
            SipConnector connector = this._connectorManager.getDefaultConnector();
            SipURIImpl route = new SipURIImpl(null, connector.getHost(), connector.getPort());
            RouterInfoUtil.encode(route, routerInfo);
            route.setLrParam(true);
            request.pushRoute(route);
        }
    }

    public void handle(SipServletMessage message) throws IOException, ServletException {
        ((SipHandler)this.getHandler()).handle(message);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.getContainer().update((Object)this, (Object)this._transactionManager, (Object)transactionManager, "transactionManager", true);
        this._transactionManager = transactionManager;
        this._transactionManager.setServer(this);
    }

    public void setConnectorManager(ConnectorManager connectorManager) {
        this.getContainer().update((Object)this, (Object)this._connectorManager, (Object)connectorManager, "connectorManager", true);
        this._connectorManager = connectorManager;
        this._connectorManager.setServer(this);
    }

    public void setSipThreadPool(ThreadPool sipThreadPool) {
        if (this._sipThreadPool != null) {
            this.removeBean(this._sipThreadPool);
        }
        this.getContainer().update((Object)this, (Object)this._sipThreadPool, (Object)sipThreadPool, "sipThreadPool", false);
        this._sipThreadPool = sipThreadPool;
        if (this._sipThreadPool != null) {
            this.addBean(this._sipThreadPool);
        }
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.getContainer().update((Object)this, (Object)this._sessionManager, (Object)sessionManager, "sessionManager", true);
        this._sessionManager = sessionManager;
        this._sessionManager.setServer(this);
    }

    public ThreadPool getSipThreadPool() {
        return this._sipThreadPool;
    }

    public ConnectorManager getConnectorManager() {
        return this._connectorManager;
    }

    public TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void allStatsReset() {
        Handler[] handlers;
        this._statsStartedAt.set(System.currentTimeMillis());
        this.getSessionManager().statsReset();
        this.getConnectorManager().statsReset();
        this.getTransactionManager().statsReset();
        if (this._handler instanceof HandlerCollection && (handlers = ((HandlerCollection)this._handler).getChildHandlersByClass(SipAppContext.class)) != null) {
            for (Handler handler : handlers) {
                ((SipAppContext)handler).statsReset();
            }
        }
    }

    public long getStatsStartedAt() {
        return this._statsStartedAt.get();
    }

    public static String getSipVersion() {
        return __sipVersion;
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        Server.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])this._connectorManager.getConnectors()), Arrays.asList(this._applicationRouter)});
    }

    public String toString() {
        return "cipango-" + __sipVersion;
    }
}

