/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.net.InetAddress;
import java.util.Random;
import org.cipango.util.HexString;

public abstract class ID {
    public static final String APP_SESSION_ID_PARAMETER = "app-session-id";
    public static final String CONTEXT_ATTRIBUTE = "context";
    public static final String SESSION_KEY_ATTRIBUTE = "session.key";
    private static String __localhost;
    private static Random __random;
    public static final int MAX_CSEQ = 65536;
    private static String __magicCookie;

    public static String newAppSessionId() {
        return ID.newID(4);
    }

    public static String newSessionId() {
        return ID.newID(4);
    }

    public static String newCallId() {
        return ID.newID(4) + '@' + __localhost;
    }

    public static String newTag() {
        return ID.newID(4);
    }

    public static String newCNonce() {
        return ID.newID(4);
    }

    public static String newBranch() {
        return "z9hG4bK" + ID.newID(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int newCSeq() {
        Random random = __random;
        synchronized (random) {
            return (int)(__random.nextDouble() * 65536.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String newID(int length) {
        byte[] b = new byte[length];
        Random random = __random;
        synchronized (random) {
            __random.nextBytes(b);
        }
        return HexString.toHexString(b);
    }

    public static String newCallId(String callId) {
        if (callId.startsWith(__magicCookie)) {
            int i = callId.indexOf(42);
            StringBuilder sb = new StringBuilder(callId.length());
            sb.append(__magicCookie);
            sb.append('-');
            sb.append(ID.newID(3));
            sb.append('*');
            sb.append(callId.substring(i + 1));
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(callId.length() + __localhost.length() + 14);
        sb.append(__magicCookie);
        sb.append('-');
        sb.append(ID.newID(3));
        sb.append('*');
        for (int i = 0; i < callId.length(); ++i) {
            char c = callId.charAt(i);
            if (c == '@') {
                sb.append('%');
                continue;
            }
            if (c == '%') {
                sb.append("%%");
                continue;
            }
            sb.append(c);
        }
        sb.append('@');
        sb.append(__localhost);
        return sb.toString();
    }

    public static String getCallSessionId(String callId) {
        if (!callId.startsWith(__magicCookie)) {
            return callId;
        }
        int i = callId.indexOf(42, __magicCookie.length() + 7);
        int j = callId.indexOf(64, i + 1);
        StringBuilder sb = null;
        boolean escape = false;
        for (int k = i + 1; k < j; ++k) {
            char c = callId.charAt(k);
            if (c == '%') {
                if (sb == null) {
                    sb = new StringBuilder(j - i);
                    sb.append(callId.substring(i + 1, k));
                }
                if (escape) {
                    sb.append('%');
                }
                escape = !escape;
                continue;
            }
            if (escape) {
                sb.append('@');
                escape = false;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return callId.substring(i + 1, j);
    }

    public static String getIdFromKey(String applicationName, String sessionKey) {
        return "skey-" + applicationName + "-" + sessionKey;
    }

    public static boolean isKey(String id) {
        return id.startsWith("skey-");
    }

    public static void main(String[] args) throws Exception {
        long ts = System.currentTimeMillis() / 1000L * 5L;
        long hi = ts & 0xFFFFFFFFL;
        long id = hi << 32;
        System.out.println(ts);
        System.out.println(hi);
        System.out.println(Long.toHexString(ts));
        System.out.println(Long.toHexString(hi));
    }

    static {
        __random = new Random();
        __magicCookie = "aK5q9iC";
        try {
            __localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            __localhost = "localhost";
        }
    }
}

