/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.server.Server;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipConnectors;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.log.AccessLog;
import org.cipango.sip.NameAddr;
import org.cipango.sip.SipGenerator;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.Via;
import org.cipango.util.SystemUtil;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConnectorManager
extends AbstractLifeCycle
implements Buffers,
SipHandler {
    private static final Logger LOG = Log.getLogger(ConnectorManager.class);
    private static final int DEFAULT_MTU = 1500;
    private static final int DEFAULT_MESSAGE_SIZE = 16384;
    private static final int MAX_MESSAGE_SIZE = 65536;
    private Server _server;
    private SipConnector[] _connectors;
    private int _mtu;
    private SipGenerator _sipGenerator;
    private AccessLog _accessLog;
    private final AtomicLong _receivedStats = new AtomicLong();
    private final AtomicLong _sentStats = new AtomicLong();
    private transient long _nbParseErrors;
    private ArrayList<Buffer> _buffers;
    private int _messageSize = 10000;
    private int _largeMessageSize = 65536;

    public ConnectorManager() {
        this._mtu = SystemUtil.getIntOrDefault("sip.mtu", 1500);
    }

    public void addConnector(SipConnector connector) {
        this.setConnectors((SipConnector[])LazyList.addToArray((Object[])this.getConnectors(), (Object)connector, SipConnector.class));
    }

    public SipConnector[] getConnectors() {
        return this._connectors;
    }

    public SipConnector getDefaultConnector() {
        if (this._connectors == null || this._connectors.length == 0) {
            return null;
        }
        return this._connectors[0];
    }

    public void setConnectors(SipConnector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                SipConnector connector = connectors[i];
                connector.setServer(this._server);
                connector.setHandler(this);
            }
        }
        if (this._server != null) {
            this._server.getContainer().update((Object)this, (Object[])this._connectors, (Object[])connectors, "connectors");
        }
        this._connectors = connectors;
    }

    public void setServer(org.eclipse.jetty.server.Server server) {
        this._server = (Server)server;
    }

    public Server getServer() {
        return this._server;
    }

    public Address getContact(int type) {
        SipConnector sc = this.findConnector(type, null);
        return new NameAddr(sc.getSipUri().clone());
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._buffers != null) {
            this._buffers.clear();
        } else {
            this._buffers = new ArrayList();
        }
        this._sipGenerator = new SipGenerator();
        if (this._accessLog instanceof LifeCycle) {
            try {
                ((LifeCycle)this._accessLog).start();
            }
            catch (Exception e) {
                LOG.warn("failed to start access log", (Throwable)e);
            }
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                SipConnector connector = this._connectors[i];
                connector.start();
            }
        }
    }

    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (this._accessLog instanceof LifeCycle) {
            try {
                ((LifeCycle)this._accessLog).stop();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
        super.doStop();
        mex.ifExceptionThrow();
    }

    public SipConnector findConnector(int type, InetAddress addr) {
        for (int i = 0; i < this._connectors.length; ++i) {
            SipConnector t = this._connectors[i];
            if (t.getTransportOrdinal() != type) continue;
            return t;
        }
        return this._connectors[0];
    }

    public void messageReceived() {
        this._receivedStats.incrementAndGet();
    }

    public void messageSent() {
        this._sentStats.incrementAndGet();
    }

    public void handle(SipServletMessage message) throws IOException, ServletException {
        SipMessage msg = (SipMessage)message;
        this.messageReceived();
        if (this._accessLog != null) {
            this._accessLog.messageReceived(msg, msg.getConnection());
        }
        if (this.preValidateMessage((SipMessage)message)) {
            if (msg.isRequest()) {
                Via via = msg.getTopVia();
                String remoteAddr = msg.getRemoteAddr();
                String host = via.getHost();
                if (host.indexOf(91) != -1) {
                    host = InetAddress.getByName(host).getHostAddress();
                }
                if (!host.equals(remoteAddr)) {
                    via.setReceived(remoteAddr);
                }
                if (via.getRport() != null) {
                    via.setRport(Integer.toString(message.getRemotePort()));
                }
            }
            this.getServer().handle(msg);
        } else {
            ++this._nbParseErrors;
        }
    }

    public boolean isLocalUri(URI uri) {
        if (!uri.isSipURI()) {
            return false;
        }
        SipURI sipUri = (SipURI)uri;
        if (!sipUri.getLrParam()) {
            return false;
        }
        String host = sipUri.getHost();
        if (host.indexOf("[") != -1) {
            try {
                host = InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.ignore((Throwable)e);
            }
        }
        for (int i = 0; i < this._connectors.length; ++i) {
            boolean samePort;
            SipConnector connector = this._connectors[i];
            String connectorHost = connector.getSipUri().getHost();
            boolean bl = samePort = connector.getPort() == sipUri.getPort() || sipUri.getPort() == -1;
            if (!samePort || !connectorHost.equals(host) && !connector.getAddr().getHostAddress().equals(host)) continue;
            if (sipUri.getPort() != -1) {
                return true;
            }
            return !connector.getAddr().getHostAddress().equals(host) || connector.getPort() == connector.getDefaultPort();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SipMessage message, SipConnection connection) throws IOException {
        Buffer buffer = this.getBuffer(this._messageSize);
        this._sipGenerator.generate(buffer, message);
        try {
            connection.write(buffer);
            if (this._accessLog != null) {
                this._accessLog.messageSent(message, connection);
            }
            this.messageSent();
        }
        finally {
            this.returnBuffer(buffer);
        }
    }

    public SipConnection getConnection(SipRequest request, int transport, InetAddress address, int port) throws IOException {
        SipConnector connector = this.findConnector(transport, address);
        Via via = request.getTopVia();
        via.setTransport(connector.getTransport());
        via.setHost(connector.getSipUri().getHost());
        via.setPort(connector.getSipUri().getPort());
        SipConnection connection = connector.getConnection(address, port);
        if (connection == null) {
            throw new IOException("Could not find connection to " + address + ":" + port + "/" + connector.getTransport());
        }
        return connection;
    }

    public void sendResponse(SipResponse response) throws IOException {
        SipRequest request = (SipRequest)response.getRequest();
        SipConnection connection = null;
        if (request != null) {
            connection = request.getConnection();
        }
        this.sendResponse(response, connection);
    }

    public void sendResponse(SipResponse response, SipConnection connection) throws IOException {
        if (connection == null || !connection.getConnector().isReliable() || !connection.isOpen()) {
            Via via = response.getTopVia();
            SipConnector connector = null;
            InetAddress address = null;
            if (connection != null) {
                connector = connection.getConnector();
                address = connection.getRemoteAddress();
            } else {
                int transport = SipConnectors.getOrdinal(via.getTransport());
                address = InetAddress.getByName(via.getHost());
                connector = this.findConnector(transport, address);
            }
            int port = -1;
            String srport = via.getRport();
            if (srport != null) {
                port = Integer.parseInt(srport);
            } else {
                port = via.getPort();
                if (port == -1) {
                    port = connection.getConnector().getDefaultPort();
                }
            }
            connection = connector.getConnection(address, port);
            if (connection == null) {
                throw new IOException("Could not found any SIP connection to " + address + ":" + port + "/" + connector.getTransport());
            }
        }
        this.send(response, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer(int size) {
        if (size == this._messageSize) {
            ArrayList<Buffer> arrayList = this._buffers;
            synchronized (arrayList) {
                if (this._buffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return this._buffers.remove(this._buffers.size() - 1);
            }
        }
        return this.newBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        int c = buffer.capacity();
        if (c == this._messageSize) {
            ArrayList<Buffer> arrayList = this._buffers;
            synchronized (arrayList) {
                this._buffers.add(buffer);
            }
        }
    }

    public Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    public static void putStringUTF8(Buffer buffer, String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        buffer.put(bytes);
    }

    public void setAccessLog(AccessLog accessLog) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)this._accessLog, (Object)accessLog, "accessLog", false);
        }
        this._accessLog = accessLog;
        try {
            if (this.isRunning() && this._accessLog instanceof LifeCycle) {
                ((LifeCycle)accessLog).start();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public long getMessagesReceived() {
        return this._receivedStats.get();
    }

    public long getMessagesSent() {
        return this._sentStats.get();
    }

    public long getNbParseError() {
        long val = this._nbParseErrors;
        for (int i = 0; this._connectors != null && i < this._connectors.length; ++i) {
            val += this._connectors[i].getNbParseError();
        }
        return val;
    }

    public void statsReset() {
        this._receivedStats.set(0L);
        this._sentStats.set(0L);
        this._nbParseErrors = 0L;
        for (int i = 0; this._connectors != null && i < this._connectors.length; ++i) {
            this._connectors[i].statsReset();
        }
    }

    public boolean preValidateMessage(SipMessage message) {
        boolean valid = true;
        try {
            if (!(this.isUnique((Buffer)SipHeaders.FROM_BUFFER, message) && this.isUnique((Buffer)SipHeaders.TO_BUFFER, message) && this.isUnique((Buffer)SipHeaders.CALL_ID_BUFFER, message) && this.isUnique((Buffer)SipHeaders.CSEQ_BUFFER, message))) {
                valid = false;
            } else if (message.getTopVia() == null || message.getFrom() == null || message.getTo() == null || message.getCSeq() == null) {
                LOG.info("Received bad message: unparsable required headers", new Object[0]);
                valid = false;
            }
            message.getAddressHeader("contact");
            if (message instanceof SipRequest) {
                SipRequest request = (SipRequest)message;
                if (request.getRequestURI() == null) {
                    valid = false;
                }
                request.getTopRoute();
                if (!request.getCSeq().getMethod().equals(request.getMethod())) {
                    LOG.info("Received bad request: CSeq method does not match", new Object[0]);
                    valid = false;
                }
            } else {
                int status = ((SipResponse)message).getStatus();
                if (status < 100 || status > 699) {
                    LOG.info("Received bad response: Invalid status code: " + status, new Object[0]);
                    valid = false;
                }
            }
        }
        catch (Exception e) {
            LOG.info("Received bad message: Some headers are not parsable: {}", (Throwable)e);
            LOG.debug("Received bad message: Some headers are not parsable", (Throwable)e);
            valid = false;
        }
        try {
            if (!valid && message instanceof SipRequest && !message.isAck() && message.getTopVia() != null) {
                SipResponse response = (SipResponse)((SipRequest)message).createResponse(400);
                this.sendResponse(response);
            }
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        return valid;
    }

    private boolean isUnique(Buffer headerName, SipMessage message) {
        ListIterator<String> it = message.getFields().getValues(headerName);
        if (!it.hasNext()) {
            LOG.info("Received bad message: Missing required header: " + headerName, new Object[0]);
            return false;
        }
        it.next();
        if (it.hasNext()) {
            LOG.info("Received bad message: Duplicate header: " + headerName, new Object[0]);
        }
        return !it.hasNext();
    }

    public AccessLog getAccessLog() {
        return this._accessLog;
    }

    public Buffer getBuffer() {
        return null;
    }

    public Buffer getHeader() {
        return null;
    }
}

