/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.sip.SipURI;
import org.cipango.io.SipBuffer;
import org.cipango.server.Server;
import org.cipango.server.SipConnector;
import org.cipango.server.SipConnectors;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.SipParser;
import org.cipango.sip.SipURIImpl;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class AbstractSipConnector
extends AbstractLifeCycle
implements SipConnector,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractSipConnector.class);
    private int _port;
    private String _host;
    private String _name;
    private String _externalHost;
    private int _externalPort = -1;
    private boolean _transportParam = false;
    private SipURI _sipUri;
    private int _acceptors = 1;
    private Thread[] _acceptorThread;
    private SipHandler _handler;
    private Server _server;
    private ThreadPool _threadPool;
    protected Object _statsLock = new Object();
    protected transient long _statsStartedAt = -1L;
    protected transient long _nbParseErrors;

    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void setHost(String host) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._host = host != null && host.contains(":") && !host.contains("[") ? "[" + host + "]" : host;
    }

    public String getHost() {
        return this._host;
    }

    public void setExternalHost(String externalHost) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._externalHost = externalHost;
    }

    public String getExternalHost() {
        return this._externalHost;
    }

    public void setExternalPort(int port) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._externalPort = port;
    }

    public int getExternalPort() {
        return this._externalPort;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getTransport() {
        return SipConnectors.getName(this.getTransportOrdinal());
    }

    public boolean isTransportParam() {
        return this._transportParam;
    }

    public void setTransportParam(boolean transportParam) {
        this._transportParam = transportParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this._port <= 0) {
            this._port = this.getDefaultPort();
        }
        if (this._host == null) {
            try {
                this._host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
                this._host = "127.0.0.1";
            }
        }
        this._sipUri = new SipURIImpl(this._name, this._externalHost != null ? this._externalHost : this._host, this._externalPort != -1 ? this._externalPort : this._port);
        if (this.isTransportParam()) {
            this._sipUri.setTransportParam(this.getTransport().toLowerCase());
        }
        if (this._threadPool == null && this.getServer() != null) {
            this._threadPool = this.getServer().getSipThreadPool();
        }
        if (this._threadPool instanceof LifeCycle && (this.getServer() == null || this._threadPool != this.getServer().getSipThreadPool())) {
            ((LifeCycle)this._threadPool).start();
        }
        this.open();
        AbstractSipConnector abstractSipConnector = this;
        synchronized (abstractSipConnector) {
            this._acceptorThread = new Thread[this.getAcceptors()];
            for (int i = 0; i < this._acceptorThread.length; ++i) {
                if (this._threadPool.dispatch((Runnable)new Acceptor(i))) continue;
                LOG.warn("insufficient maxThreads configured for {}", new Object[]{this});
                break;
            }
        }
        LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (this._server != null && this._threadPool == this._server.getSipThreadPool()) {
            this._threadPool = null;
        }
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        super.doStop();
        Thread[] acceptors = null;
        AbstractSipConnector abstractSipConnector = this;
        synchronized (abstractSipConnector) {
            acceptors = this._acceptorThread;
            this._acceptorThread = null;
        }
        if (acceptors != null) {
            for (int i = 0; i < acceptors.length; ++i) {
                Thread thread = acceptors[i];
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    public abstract void accept(int var1) throws IOException, InterruptedException;

    public void process(SipMessage message) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.getThreadPool().dispatch((Runnable)new MessageTask(message))) {
            LOG.warn("No threads to dispatch message from {}:{}", new Object[]{message.getRemoteAddr(), message.getRemotePort()});
        }
    }

    public void setHandler(SipHandler handler) {
        this._handler = handler;
    }

    public SipHandler getHandler() {
        return this._handler;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public void setAcceptors(int acceptors) {
        this._acceptors = acceptors;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public SipURI getSipUri() {
        return this._sipUri;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + "@" + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    public long getNbParseError() {
        return this._nbParseErrors;
    }

    public void statsReset() {
        this._statsStartedAt = this._statsStartedAt == -1L ? -1L : System.currentTimeMillis();
        this._nbParseErrors = 0L;
    }

    public void setStatsOn(boolean on) {
        if (on && this._statsStartedAt != -1L) {
            return;
        }
        this.statsReset();
        this._statsStartedAt = on ? System.currentTimeMillis() : -1L;
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
        if (this._externalHost != null) {
            AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList("ExternalHost: " + this._externalHost, "ExternalPort: " + this._externalPort)});
        }
    }

    public static class EventHandler
    extends SipParser.EventHandler {
        public static final String UTF_8 = "UTF-8";
        private SipMessage msg;
        private Exception exception;
        private boolean _prevPong = false;
        private boolean _pong = false;
        private long _lastEvent;

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            try {
                SipRequest request = new SipRequest();
                if (!(method instanceof BufferCache.CachedBuffer) && LOG.isDebugEnabled()) {
                    LOG.debug("Unknown method: " + method, new Object[0]);
                }
                request.setMethod(method.toString());
                request.setRequestURI(uri);
                this.msg = request;
            }
            catch (Exception e) {
                this.exception = e;
                throw new IOException("Parsing error");
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            SipResponse response = new SipResponse();
            response.setStatus(status, reason.toString());
            this.msg = response;
        }

        public SipMessage getMessage() {
            return this.msg;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void header(Buffer name, Buffer value) throws IOException {
            if (this.msg == null) {
                throw new IOException("!status line");
            }
            this.add(name, value);
        }

        public void content(Buffer buffer) throws IOException {
            if (buffer.length() > 0) {
                this.msg.setRawContent(buffer.asArray());
            }
        }

        public void keepAlive() throws IOException {
            this._pong = true;
        }

        public void reset() {
            this.msg = null;
            this.exception = null;
            this._prevPong = this._pong && !this._prevPong;
            this._pong = false;
            this._lastEvent = System.currentTimeMillis();
        }

        private byte[] asArray(byte[] src, int index, int length) {
            byte[] bytes = new byte[length];
            System.arraycopy(src, index, bytes, 0, length);
            return bytes;
        }

        public void add(Buffer name, Buffer value) {
            if (!name.isImmutable()) {
                name = new SipBuffer(name.asArray());
            }
            if (SipHeaders.getType(name).isList()) {
                int end;
                boolean quote = false;
                int start = value.getIndex();
                byte[] b = value.array();
                int startValue = start;
                int endValue = end;
                for (end = value.putIndex(); end > start && b[end - 1] <= 32; --end) {
                }
                for (int i = start; i < end; ++i) {
                    byte c = b[i];
                    if (c == 34) {
                        boolean bl = quote = !quote;
                    }
                    if (c != 44 || quote) continue;
                    for (endValue = i; endValue > start && b[endValue - 1] <= 32; --endValue) {
                    }
                    while (startValue < endValue && b[startValue] <= 32) {
                        ++startValue;
                    }
                    byte[] bValue = this.asArray(b, startValue, endValue - startValue);
                    this.msg.getFields().addBuffer((Buffer)name, (Buffer)new ByteArrayBuffer(bValue));
                    startValue = i + 1;
                }
                while (startValue < end && b[startValue] <= 32) {
                    ++startValue;
                }
                byte[] bValue = this.asArray(b, startValue, end - startValue);
                this.msg.getFields().addBuffer((Buffer)name, (Buffer)new ByteArrayBuffer(bValue));
            } else {
                this.msg.getFields().addBuffer((Buffer)name, (Buffer)new ByteArrayBuffer(value.asArray()));
            }
        }

        public boolean isPing() {
            return this._prevPong && this._pong && System.currentTimeMillis() - this._lastEvent < 500L;
        }

        public long getLastEvent() {
            return this._lastEvent;
        }

        public boolean isPong() {
            return this._pong && !this.isPing();
        }
    }

    class MessageTask
    implements Runnable {
        private SipMessage _message;

        public MessageTask(SipMessage message) {
            this._message = message;
        }

        public void run() {
            try {
                AbstractSipConnector.this.getHandler().handle(this._message);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread current = Thread.currentThread();
            AbstractSipConnector abstractSipConnector = AbstractSipConnector.this;
            synchronized (abstractSipConnector) {
                if (AbstractSipConnector.this._acceptorThread == null) {
                    return;
                }
                ((AbstractSipConnector)AbstractSipConnector.this)._acceptorThread[this._acceptor] = current;
            }
            String name = AbstractSipConnector.this._acceptorThread[this._acceptor].getName();
            current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractSipConnector.this);
            int old_priority = current.getPriority();
            try {
                while (AbstractSipConnector.this.isRunning() && AbstractSipConnector.this.getConnection() != null) {
                    try {
                        AbstractSipConnector.this.accept(this._acceptor);
                    }
                    catch (IOException ioe) {
                        LOG.ignore((Throwable)ioe);
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }
            finally {
                current.setPriority(old_priority);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractSipConnector.this.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                AbstractSipConnector abstractSipConnector2 = AbstractSipConnector.this;
                synchronized (abstractSipConnector2) {
                    if (AbstractSipConnector.this._acceptorThread != null) {
                        ((AbstractSipConnector)AbstractSipConnector.this)._acceptorThread[this._acceptor] = null;
                    }
                }
            }
        }
    }
}

