/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.http.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.server.session.AppSessionIf;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.SessionManager;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConvergedSessionManager
extends HashSessionManager {
    private static final Logger LOG = Log.getLogger(ConvergedSessionManager.class);

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    public class Session
    extends HashedSession
    implements ConvergedHttpSession {
        private AppSessionIf _appSession;
        private String _serverName;
        private String _scheme;
        private int _port;
        private int _confidentialPort;

        protected Session(HttpServletRequest httpServletRequest) {
            super((HashSessionManager)ConvergedSessionManager.this, httpServletRequest);
            Request request = (Request)httpServletRequest;
            this._serverName = request.getServerName();
            this._scheme = request.getScheme();
            this._confidentialPort = request.getConnection().getConnector().getConfidentialPort();
            this._port = request.getServerPort();
            this.updateSession((HttpServletRequest)request);
        }

        public void updateSession(HttpServletRequest request) {
            String path_params;
            String appId = null;
            String uri = request.getRequestURI();
            int semi = uri.lastIndexOf(59);
            if (semi >= 0 && (path_params = uri.substring(semi + 1)) != null && path_params.startsWith("app-session-id")) {
                appId = path_params.substring("app-session-id".length() + 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got App ID " + appId + " from URL", new Object[0]);
                }
            }
            if (appId != null && !appId.trim().equals("")) {
                appId = appId.replace("%3B", ";");
                AppSessionIf appSession = (AppSessionIf)this.getSipAppContext().getSipSessionsUtil().getApplicationSessionById(appId);
                if (appSession != null && appSession.isValid()) {
                    if (this.isValid() && this._appSession == null) {
                        appSession.getAppSession().addSession((Object)this);
                    }
                    this._appSession = appSession;
                }
            }
        }

        private SipAppContext getSipAppContext() {
            return (SipAppContext)ConvergedSessionManager.this._context.getContextHandler();
        }

        public String encodeURL(String url) {
            String sessionURLPrefix = ConvergedSessionManager.this.getSessionIdPathParameterNamePrefix();
            String id = this.getNodeId();
            int prefix = url.indexOf(sessionURLPrefix);
            if (prefix != -1) {
                int suffix = url.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return url.substring(0, prefix + sessionURLPrefix.length()) + id;
                }
                return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
            }
            int suffix = url.indexOf(63);
            if (suffix < 0) {
                suffix = url.indexOf(35);
            }
            if (suffix < 0) {
                return url + sessionURLPrefix + id;
            }
            return url.substring(0, suffix) + sessionURLPrefix + id + url.substring(suffix);
        }

        public String encodeURL(String relativePath, String scheme) {
            StringBuffer sb = new StringBuffer();
            sb.append(scheme).append("://");
            sb.append(this._serverName);
            if (this._scheme.equalsIgnoreCase(scheme)) {
                if (this._port > 0 && (scheme.equalsIgnoreCase("http") && this._port != 80 || scheme.equalsIgnoreCase("https") && this._port != 443)) {
                    sb.append(':').append(this._port);
                }
            } else if ("https".equals(scheme) && this._confidentialPort != 0) {
                if (this._confidentialPort != 443) {
                    sb.append(':').append(this._port);
                }
            } else {
                throw new IllegalArgumentException("Scheme " + scheme + " is not the scheme used for this session " + " and unable to detect the port for this scheme");
            }
            sb.append(this.getSipAppContext().getContextPath());
            sb.append(relativePath);
            return this.encodeURL(sb.toString());
        }

        public SipApplicationSession getApplicationSession() {
            if (this._appSession == null) {
                this._appSession = (AppSessionIf)this.getSipAppContext().getSipFactory().createApplicationSession();
                if (this.isValid()) {
                    this._appSession.getAppSession().addSession((Object)this);
                }
            }
            return this._appSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean access(long time) {
            boolean access = super.access(time);
            if (this._appSession != null) {
                CallSession call = this._appSession.getAppSession().getCallSession();
                SessionManager.SessionScope scope = call.getServer().getSessionManager().openScope(call);
                try {
                    this._appSession.getAppSession().access(time);
                }
                finally {
                    scope.close();
                }
            }
            return access;
        }

        protected void doInvalidate() throws IllegalStateException {
            super.doInvalidate();
            if (this._appSession != null) {
                this._appSession.getAppSession().removeSession((Object)this);
            }
        }
    }
}

