/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.util;

public class PriorityQueue {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    protected Node[] _heap;
    protected int _size;

    public PriorityQueue() {
        this(11);
    }

    public PriorityQueue(int initialSize) {
        this._heap = new Node[initialSize];
    }

    public int getSize() {
        return this._size;
    }

    public void offer(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node._position > 0) {
            this.remove(node);
        }
        if (++this._size == this._heap.length) {
            Node[] newHeap = new Node[this._heap.length * 2];
            System.arraycopy(this._heap, 0, newHeap, 0, this._heap.length);
            this._heap = newHeap;
        }
        if (this._size == 1) {
            this.set(this._size, node);
        } else {
            this.siftUp(this._size, node);
        }
    }

    public Node poll() {
        if (this._size == 0) {
            return null;
        }
        Node node = this._heap[1];
        node._position = -1;
        Node x = this._heap[this._size];
        this._heap[this._size--] = null;
        if (this._size != 0) {
            this.siftDown(1, x);
        }
        return node;
    }

    public Node peek() {
        return this._size > 0 ? this._heap[1] : null;
    }

    private void siftUp(int k, Node x) {
        while (k > 1) {
            int j = k >>> 1;
            Node parent = this._heap[j];
            if (parent._value <= x._value) break;
            this.set(k, parent);
            k = j;
        }
        this.set(k, x);
    }

    private void siftDown(int k, Node x) {
        int j;
        while ((j = k << 1) <= this._size) {
            Node child = this._heap[j];
            if (j < this._size && child._value > this._heap[j + 1]._value) {
                child = this._heap[++j];
            }
            if (x._value <= child._value) break;
            this.set(k, child);
            k = j;
        }
        this.set(k, x);
    }

    public void remove(Node node) {
        if (node._position != -1) {
            this.removeAt(node._position);
        }
        node._position = -1;
    }

    private void removeAt(int i) {
        if (i == 0 || i > this._size) {
            throw new IllegalArgumentException("0<" + i + "<=" + this._size);
        }
        if (i == this._size) {
            this._heap[this._size--] = null;
        } else {
            Node node = this._heap[this._size];
            this._heap[this._size--] = null;
            this.siftDown(i, node);
            if (this._heap[i] == node) {
                this.siftUp(i, node);
            }
        }
    }

    private final void set(int k, Node node) {
        this._heap[k] = node;
        node._position = k;
    }

    public void offer(Node node, long time) {
        if (node._position > 0) {
            long oldTime = this._heap[((Node)node)._position]._value;
            this._heap[((Node)node)._position]._value = time;
            if (oldTime < time) {
                this.siftDown(node._position, node);
            } else {
                this.siftUp(node._position, node);
            }
        } else {
            node._value = time;
            this.offer(node);
        }
    }

    protected Node[] asArray() {
        Node[] nodes = new Node[this._size];
        System.arraycopy(this._heap, 1, nodes, 0, this._size);
        return nodes;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        for (int i = 1; i <= this._size; ++i) {
            buf.append(this._heap[i]);
            if (i >= this._size) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    public static class Node {
        private int _position = -1;
        protected long _value;

        public Node(long value) {
            this._value = value;
        }

        public long getValue() {
            return this._value;
        }

        protected int getPosition() {
            return this._position;
        }
    }
}

