/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap.util;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import org.apache.log4j.Logger;
import org.cipango.kaleo.xcap.XcapException;
import org.cipango.kaleo.xcap.util.ResourceEntityResolver;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.iso_relax.verifier.VerifierHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XcapUtil {
    protected static final Logger log = Logger.getLogger(XcapUtil.class);
    private static VerifierFactory _factory = new TheFactoryImpl();

    public static Schema getSchema(String xsdResource) {
        try {
            return _factory.compileSchema(XcapUtil.class.getResourceAsStream(xsdResource));
        }
        catch (Exception e) {
            log.error((Object)("Unable to compile schema: " + xsdResource), (Throwable)e);
            return null;
        }
    }

    public static void validate(Document document, Schema schema) throws XcapException {
        try {
            Verifier verifier = schema.newVerifier();
            verifier.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException saxParseEx) {
                    log.error((Object)"Error during validation.", (Throwable)saxParseEx);
                }

                public void fatalError(SAXParseException saxParseEx) {
                    log.fatal((Object)"Fatal error during validation.", (Throwable)saxParseEx);
                }

                public void warning(SAXParseException saxParseEx) {
                    log.warn((Object)saxParseEx);
                }
            });
            VerifierHandler handler = verifier.getVerifierHandler();
            verifier.verify((Node)document);
            if (!handler.isValid()) {
                XcapException e1 = new XcapException("Unable to validate document after insertion", 409);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
                sb.append("<schema-validation-error/>");
                sb.append("\n</xcap-error>");
                e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
                throw e1;
            }
        }
        catch (XcapException e) {
            throw e;
        }
        catch (Throwable e) {
            XcapException e1 = new XcapException("Unable to validate document after insertion", 409, e);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<schema-validation-error/>");
            sb.append("\n</xcap-error>");
            e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e1;
        }
    }

    public static boolean validate(Node node, Schema schema) throws SAXException, VerifierConfigurationException {
        Verifier verifier = schema.newVerifier();
        verifier.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException saxParseEx) {
                log.error((Object)"Error during validation.", (Throwable)saxParseEx);
            }

            public void fatalError(SAXParseException saxParseEx) {
                log.fatal((Object)"Fatal error during validation.", (Throwable)saxParseEx);
            }

            public void warning(SAXParseException saxParseEx) {
                log.warn((Object)saxParseEx);
            }
        });
        VerifierHandler handler = verifier.getVerifierHandler();
        verifier.verify(node);
        return handler.isValid();
    }

    public static String insertDefaultNamespace(String nodeSelector, String defaultNamespace) {
        StringBuffer sb = new StringBuffer(nodeSelector);
        int indexSlash = sb.indexOf("/");
        while (indexSlash != -1) {
            boolean hasNamespacePrefix;
            int nextSlash = sb.indexOf("/", indexSlash + 1);
            int nsSepIndex = sb.indexOf(":", indexSlash);
            int indexQuoteMark = sb.indexOf("\"", indexSlash);
            if (indexQuoteMark != -1 && indexQuoteMark < nsSepIndex) {
                nsSepIndex = -1;
            }
            boolean slashLastChar = indexSlash + 1 == sb.length();
            boolean isAttribute = !slashLastChar && sb.charAt(indexSlash + 1) == '@';
            boolean bl = hasNamespacePrefix = nsSepIndex != -1 && (nsSepIndex < nextSlash || nextSlash == -1);
            if (!(isAttribute || hasNamespacePrefix || slashLastChar)) {
                sb.insert(indexSlash + 1, defaultNamespace + ":");
            }
            indexSlash = sb.indexOf("/", indexSlash + 1);
        }
        return sb.toString();
    }

    static {
        _factory.setEntityResolver((EntityResolver)new ResourceEntityResolver());
    }
}

