/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.cipango.kaleo.xcap.XcapException;
import org.cipango.kaleo.xcap.XcapResource;
import org.cipango.kaleo.xcap.XcapResourceImpl;
import org.cipango.kaleo.xcap.XcapResourceProcessor;
import org.cipango.kaleo.xcap.XcapUri;
import org.cipango.kaleo.xcap.dao.XcapDao;
import org.cipango.kaleo.xcap.dao.XmlResource;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileXcapDao
implements XcapDao {
    private Logger _log = LoggerFactory.getLogger(FileXcapDao.class);
    private File _baseDir;
    private boolean _createUser = true;
    private static TransformerFactory _transformerfactory = TransformerFactory.newInstance();

    @Override
    public void init(Collection<XcapResourceProcessor> processors) throws Exception {
        if (this._baseDir == null) {
            throw new IllegalAccessException("Base dirctory is not set");
        }
        this._baseDir.mkdirs();
        if (!this._baseDir.isDirectory()) {
            throw new IllegalAccessException("Base directory " + this._baseDir + " is not a directory");
        }
        if (!this._baseDir.canWrite()) {
            throw new IllegalAccessException("Base directory " + this._baseDir + " is not writable");
        }
        for (XcapResourceProcessor processor : processors) {
            File file = new File(this._baseDir, processor.getAuid());
            file.mkdir();
            new File(file, "global").mkdir();
            new File(file, "users").mkdir();
        }
        this._log.debug("File XCAP DAO is started with base directory: {}", (Object)this._baseDir);
    }

    @Override
    public void delete(XcapResource resource) throws XcapException {
        if (!resource.isAllDocument()) {
            Node node = resource.getSelectedResource().getDom();
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                attr.getOwnerElement().removeAttribute(node.getLocalName());
            } else {
                node.getParentNode().removeChild(node);
            }
        }
    }

    @Override
    public XmlResource getDocument(XcapUri uri, boolean create) throws XcapException {
        File file = this.getFile(uri);
        if (!file.exists()) {
            if (!uri.isGlobal() && this._createUser && !file.getParentFile().exists() && file.getParentFile().getName().equals(this.getEscapePath(uri.getUser()))) {
                file.getParentFile().mkdir();
            }
            return null;
        }
        if (file.isDirectory()) {
            this._log.debug("Find resource with document selector {}, but is a directory", (Object)uri.getDocumentSelector());
            return null;
        }
        return new FileXmlResource(file);
    }

    @Override
    public XmlResource getNode(XcapResource resource) throws XcapException {
        return this.getNode(resource, resource.getXcapUri().getNodeSelector());
    }

    @Override
    public XmlResource getNode(XcapResource resource, String nodeSelector) throws XcapException {
        try {
            DOMXPath xPath = new DOMXPath(nodeSelector);
            for (String prefix : resource.getNamespaceContext().keySet()) {
                xPath.addNamespace(prefix, resource.getNamespaceContext().get(prefix));
            }
            Node node = (Node)xPath.selectSingleNode((Object)resource.getDocument().getDom());
            if (node == null) {
                return null;
            }
            return new XpathXmlResource(node);
        }
        catch (JaxenException e) {
            throw XcapException.newInternalError(e);
        }
    }

    @Override
    public void save(XcapResource resource) throws XcapException, IOException {
        if ("DELETE".equals(resource.getAction()) && resource.isAllDocument()) {
            FileXmlResource res = (FileXmlResource)resource.getDocument();
            res.getFile().delete();
            resource.setDocument(null);
            return;
        }
        File file = ((FileXmlResource)resource.getDocument()).getFile();
        try {
            FileOutputStream os = new FileOutputStream(file);
            os.write(FileXcapDao.getContent(resource.getDocument().getDom(), false));
            os.close();
        }
        catch (Exception e) {
            throw new XcapException("Unable to save document in " + file, 500, e);
        }
    }

    @Override
    public void update(XcapResource resource, String content) throws XcapException {
        if (resource.getDocument() != null) {
            ((FileXmlResource)resource.getDocument()).setModified(true);
        }
        if (resource.getNodeType() != null && resource.getNodeType() == XcapResourceImpl.NodeType.ATTRIBUTE) {
            if (resource.isCreation()) {
                XmlResource parent = this.getNode(resource, resource.getParentPath());
                Element element = (Element)parent.getDom();
                element.setAttribute(resource.getNodeName(), content);
            } else {
                Attr attr = (Attr)resource.getSelectedResource().getDom();
                attr.setValue(content);
            }
        } else {
            Document document = null;
            try {
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(new ByteArrayInputStream(content.getBytes())));
                document = parser.getDocument();
            }
            catch (Throwable e) {
                XcapException e1 = new XcapException("Unable to read XML content", 409, e);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
                sb.append("<not-well-formed/>");
                sb.append("\n</xcap-error>");
                e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
                throw e1;
            }
            if (resource.isAllDocument()) {
                resource.setDocument(new FileXmlResource(this.getFile(resource.getXcapUri()), document));
            } else if (resource.isCreation()) {
                XmlResource parent = this.getNode(resource, resource.getParentPath());
                Node newNode = parent.getDom().getOwnerDocument().importNode(document.getDocumentElement(), true);
                parent.getDom().appendChild(newNode);
            } else {
                Node previous = resource.getSelectedResource().getDom();
                Node newNode = previous.getOwnerDocument().importNode(document.getDocumentElement(), true);
                previous.getParentNode().replaceChild(newNode, previous);
                ((XpathXmlResource)resource.getSelectedResource()).setNode(newNode);
            }
        }
    }

    private File getFile(XcapUri uri) {
        return new File(this._baseDir, this.getEscapePath(uri.getDocumentSelector()));
    }

    private String getEscapePath(String path) {
        return path.replace(":", "%3A").replace("@", "%40");
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public void setBaseDir(File baseDir) {
        this._baseDir = baseDir;
    }

    private static byte[] getContent(Node node, boolean omitXmlDeclaration) {
        try {
            DOMSource domSource = new DOMSource(node);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            Transformer transformer = _transformerfactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
            transformer.transform(domSource, new StreamResult(byteOut));
            return byteOut.toByteArray();
        }
        catch (TransformerException e) {
            throw XcapException.newInternalError(e);
        }
    }

    @Override
    public String getFirstExistAncestor(XcapUri uri) {
        File file = this.getFile(uri);
        while (!file.exists() && !file.equals(this._baseDir)) {
            file = file.getParentFile();
        }
        if (file.equals(this._baseDir)) {
            return "";
        }
        return file.getAbsolutePath().substring(this._baseDir.getAbsolutePath().length() + 1).replace('\\', '/');
    }

    public static class FileXmlResource
    implements XmlResource {
        private File _file;
        private Document _document;
        public boolean _modified = false;

        public FileXmlResource(File file) {
            this._file = file;
        }

        public FileXmlResource(File file, Document document) {
            this._file = file;
            this._document = document;
            this._modified = true;
        }

        public byte[] getBytes() {
            if (this._modified) {
                return FileXcapDao.getContent(this._document, false);
            }
            try {
                int read;
                FileInputStream is = new FileInputStream(this._file);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] b = new byte[512];
                while ((read = is.read(b)) != -1) {
                    os.write(b, 0, read);
                }
                b = os.toByteArray();
                os.close();
                is.close();
                return b;
            }
            catch (IOException e) {
                throw XcapException.newInternalError(e);
            }
        }

        public Node getDom() {
            if (this._document == null) {
                try {
                    DOMParser parser = new DOMParser();
                    parser.parse(new InputSource(new FileInputStream(this._file)));
                    this._document = parser.getDocument();
                }
                catch (Exception e) {
                    throw XcapException.newInternalError(e);
                }
            }
            return this._document;
        }

        protected File getFile() {
            return this._file;
        }

        protected void setModified(boolean modified) {
            this._modified = modified;
        }
    }

    public static class XpathXmlResource
    implements XmlResource {
        private Node _node;

        public XpathXmlResource(Node node) {
            this._node = node;
        }

        public byte[] getBytes() {
            return FileXcapDao.getContent(this._node, true);
        }

        public Node getDom() {
            return this._node;
        }

        public void setNode(Node node) {
            this._node = node;
        }
    }
}

