/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap;

import org.cipango.kaleo.xcap.XcapException;
import org.cipango.kaleo.xcap.util.RequestUtil;

public class XcapUri {
    public static final String NODE_SELECTOR_SEPARATOR = "/~~";
    public static final String USERS = "users";
    public static final String GLOBAL = "global";
    private String _nodeSelector;
    private String _documentSelector;
    private String _auid;
    private boolean _global;
    private String _user;
    private String _resourceId;

    public XcapUri(String auid, String user, String document, String nodeSelector) throws XcapException {
        this._auid = auid;
        this._user = user;
        this._documentSelector = this._auid + '/' + USERS + '/' + user + '/' + document;
        this._nodeSelector = nodeSelector;
        this._global = false;
    }

    public XcapUri(String documentSelector) throws XcapException {
        this.parse(documentSelector);
    }

    public XcapUri(String requestUri, String rootName) throws XcapException {
        this.parse(this.getRequestUriWithoutRootName(RequestUtil.URLDecode(requestUri), rootName));
    }

    private void parse(String requestUriWithoutRootName) {
        int separator = requestUriWithoutRootName.indexOf(NODE_SELECTOR_SEPARATOR);
        if (separator == -1) {
            this._documentSelector = requestUriWithoutRootName;
        } else {
            this._documentSelector = requestUriWithoutRootName.substring(0, separator);
            this._nodeSelector = requestUriWithoutRootName.substring(separator + NODE_SELECTOR_SEPARATOR.length());
        }
        if (this._documentSelector.indexOf(47) == -1) {
            throw new XcapException("Request URI " + requestUriWithoutRootName + " does not contains a second '/'", 404);
        }
        String[] docParts = this._documentSelector.split("/");
        this._auid = docParts[0];
        this._resourceId = this._documentSelector.substring(this._auid.length() + 1).replaceAll(":", "%3A").replaceAll("/", "%2F");
        if (GLOBAL.equals(docParts[1])) {
            this._global = true;
        } else if (USERS.equals(docParts[1])) {
            if (docParts.length >= 3) {
                this._user = docParts[2];
            }
            this._global = false;
        } else {
            throw new XcapException("Request URI " + requestUriWithoutRootName + " is not in subtree global or users", 400);
        }
    }

    private String getRequestUriWithoutRootName(String requestUri, String rootName) throws XcapException {
        if (!requestUri.startsWith(rootName)) {
            throw new XcapException("Request URI " + requestUri + " does not start with '" + rootName + "'", 404);
        }
        return requestUri.substring(rootName.length());
    }

    public String getNodeSelector() {
        return this._nodeSelector;
    }

    public boolean hasNodeSeparator() {
        return this._nodeSelector != null;
    }

    public String getDocumentSelector() {
        return this._documentSelector;
    }

    public String getAuid() {
        return this._auid;
    }

    public boolean isGlobal() {
        return this._global;
    }

    public String getUser() {
        return this._user;
    }

    public String getResourceId() {
        return this._resourceId;
    }

    public String toString() {
        if (!this.hasNodeSeparator()) {
            return this._documentSelector;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._documentSelector).append(NODE_SELECTOR_SEPARATOR).append(this._nodeSelector);
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XcapUri)) {
            return false;
        }
        XcapUri other = (XcapUri)object;
        if (!this._documentSelector.equals(other.getDocumentSelector())) {
            return false;
        }
        if (this._nodeSelector == null) {
            return other.getNodeSelector() == null;
        }
        return this._nodeSelector.equals(other.getNodeSelector());
    }
}

