/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.cipango.kaleo.xcap.XcapCapsProcessor;
import org.cipango.kaleo.xcap.XcapException;
import org.cipango.kaleo.xcap.XcapListener;
import org.cipango.kaleo.xcap.XcapProcessorImpl;
import org.cipango.kaleo.xcap.XcapResource;
import org.cipango.kaleo.xcap.XcapResourceImpl;
import org.cipango.kaleo.xcap.XcapResourceProcessor;
import org.cipango.kaleo.xcap.XcapUri;
import org.cipango.kaleo.xcap.dao.XcapDao;
import org.cipango.kaleo.xcap.dao.XmlResource;
import org.cipango.kaleo.xcap.util.HexString;
import org.cipango.kaleo.xcap.util.RequestUtil;
import org.cipango.kaleo.xcap.util.XcapUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapService
extends AbstractLifeCycle {
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String GET = "GET";
    private static final String XPOINTER_PREFIX = "xmlns(";
    private static final String XPOINTER_PREFIX_REGEX = "xmlns\\(";
    private final Logger _log = LoggerFactory.getLogger(XcapService.class);
    private Map<String, XcapResourceProcessor> _processors;
    private XcapDao _dao;
    private boolean _validate;
    private boolean _validateOnGet;
    private String _rootName;
    private Map<String, List<XcapListener>> _listeners = new HashMap<String, List<XcapListener>>();

    protected void doStart() throws Exception {
        this.setRootName("xcap");
        this._validateOnGet = false;
        this._validate = false;
        this._processors = new HashMap<String, XcapResourceProcessor>();
        this.createIetfProcessors();
        this.createOmaProcessors();
        this._dao.init(this._processors.values());
        this.initXcapCaps();
    }

    public void createIetfProcessors() {
        XcapProcessorImpl processor = new XcapProcessorImpl();
        processor.setAuid("resource-lists");
        processor.setDefaultNamespacePrefix("rl");
        processor.setMimeType("application/resource-lists+xml");
        HashMap<String, String> namespaceContext = new HashMap<String, String>();
        namespaceContext.put("rl", "urn:ietf:params:xml:ns:resource-lists");
        processor.setNamespaceContext(namespaceContext);
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("pres-rules");
        processor.setDefaultNamespacePrefix("cr");
        processor.setMimeType("application/auth-policy+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("pr", "urn:ietf:params:xml:ns:pres-rules");
        namespaceContext.put("cr", "urn:ietf:params:xml:ns:common-policy");
        processor.setNamespaceContext(namespaceContext);
        processor.setXsdSchemaPath("/schema/common-policy.xsd");
        processor.setName("Presence-rules processor");
        this.addProcessor(processor);
        this.addProcessor(new XcapCapsProcessor());
    }

    public void createOmaProcessors() {
        XcapProcessorImpl processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.access-rules");
        processor.setDefaultNamespacePrefix("cr");
        processor.setMimeType("application/auth-policy+xml");
        HashMap<String, String> namespaceContext = new HashMap<String, String>();
        namespaceContext.put("pr", "urn:ietf:params:xml:ns:pres-rules");
        namespaceContext.put("cr", "urn:ietf:params:xml:ns:common-policy");
        namespaceContext.put("cp", "urn:oma:xml:xdm:common-policy");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA shared policy processor");
        processor.setXsdSchemaPath("/schema/common-policy.xsd");
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.pres-rules");
        processor.setDefaultNamespacePrefix("cr");
        processor.setMimeType("application/auth-policy+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("pr", "urn:ietf:params:xml:ns:pres-rules");
        namespaceContext.put("cr", "urn:ietf:params:xml:ns:common-policy");
        namespaceContext.put("cp", "urn:oma:xml:xdm:common-policy");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA presence rules processor");
        processor.setXsdSchemaPath("/schema/common-policy.xsd");
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.group-usage-list");
        processor.setDefaultNamespacePrefix("rl");
        processor.setMimeType("application/vnd.oma.group-usage-list+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("rl", "urn:ietf:params:xml:ns:resource-lists");
        namespaceContext.put("oru", "urn:oma:xml:xdm:resource-list:oma-uriusage");
        namespaceContext.put("oxe", "urn:oma:xml:xdm:extensions");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA group usage list processor");
        processor.setXsdSchemaPath("/schema/OMA-SUP-XSD_xdm_extensions-V1_0-20080916-C.xsd");
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.user-profile");
        processor.setDefaultNamespacePrefix("ur");
        processor.setMimeType("application/vnd.oma.user-profile+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("ur", "urn:oma:xml:xdm:user-profile");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA shared profile XDM processor");
        processor.setXsdSchemaPath("/schema/OMA-SUP-XSD_xdm_userProfile-V1_0-20070724-C.xsd");
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.locked-user-profile");
        processor.setDefaultNamespacePrefix("ur");
        processor.setMimeType("application/vnd.oma.user-profile+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("ur", "urn:oma:xml:xdm:user-profile");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA locked user profile processor");
        processor.setXsdSchemaPath("/schema/OMA-SUP-XSD_xdm_userProfile-V1_0-20070724-C.xsd");
        this.addProcessor(processor);
        processor = new XcapProcessorImpl();
        processor.setAuid("org.openmobilealliance.groups");
        processor.setDefaultNamespacePrefix("ls");
        processor.setMimeType("application/vnd.oma.poc.groups+xml");
        namespaceContext = new HashMap();
        namespaceContext.put("ls", "urn:oma:xml:poc:list-service");
        processor.setNamespaceContext(namespaceContext);
        processor.setName("OMA shared group XDM processor");
        this.addProcessor(processor);
    }

    private void initXcapCaps() throws XcapException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<xcap-caps xmlns=\"urn:ietf:params:xml:ns:xcap-caps\"\n");
        sb.append("  xmlns:xsi=\"htt//www.w3.org/2001/XMLSchema-instance\"\n");
        sb.append("  xsi:schemaLocation=\"urn:ietf:params:xml:ns:xcap-caps xcap-caps.xsd\">\n");
        sb.append("<auids>\n");
        for (XcapResourceProcessor processor : this._processors.values()) {
            sb.append("\t<auid>").append(processor.getAuid()).append("</auid>\n");
        }
        sb.append("</auids>\n");
        sb.append("<namespaces>\n");
        for (XcapResourceProcessor processor : this._processors.values()) {
            for (String namespace : processor.getNamespaceContext().values()) {
                sb.append("\t<namespace>").append(namespace).append("</namespace>\n");
            }
        }
        sb.append("</namespaces>\n");
        sb.append("</xcap-caps>");
        XcapResourceImpl resource = this.getResource(new XcapUri("xcap-caps/global/index", ""), true, "", null);
        this._dao.update(resource, sb.toString());
        this._dao.save(resource);
    }

    public void addProcessor(XcapResourceProcessor processor) {
        this._processors.put(processor.getAuid(), processor);
    }

    public boolean isAuidRegistered(String auid) {
        return this._processors.containsKey(auid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XcapResourceImpl getResource(XcapUri xcapUri, boolean isPut, String requestUrlHead, Map<String, String> requestNamespaceContext) throws XcapException {
        XcapResourceImpl.NodeType nodeType;
        XcapResourceProcessor processor = this._processors.get(xcapUri.getAuid());
        if (processor == null) {
            throw new XcapException("Not supported auid: " + xcapUri.getAuid() + " in URI: " + xcapUri, 404);
        }
        Document document = null;
        XcapResourceImpl resource = new XcapResourceImpl();
        resource.setXcapUri(xcapUri);
        resource.setProcessor(processor);
        XmlResource xmlResource = this._dao.getDocument(xcapUri, isPut && !xcapUri.hasNodeSeparator());
        if (xmlResource == null) {
            if (isPut) {
                this.locatingParent(xcapUri, requestUrlHead);
                resource.setCreation(true);
                return resource;
            }
            XcapException e = new XcapException("Resource: " + xcapUri.getDocumentSelector() + " not found", 404);
            e.setLevel(Level.INFO);
            throw e;
        }
        resource.setDocument(xmlResource);
        if (this._validateOnGet) {
            try {
                XcapUtil.validate(document, processor.getXsdSchema());
            }
            catch (XcapException e) {
                this._log.warn("Unable to validated document:" + e.getMessage(), (Throwable)e);
            }
        }
        if (resource.isAllDocument()) {
            return resource;
        }
        String nodeSelector = XcapUtil.insertDefaultNamespace(xcapUri.getNodeSelector(), processor.getDefaultNamespacePrefix());
        if (this._log.isDebugEnabled()) {
            this._log.debug("select node " + nodeSelector + " in " + xcapUri.getDocumentSelector());
        }
        if (requestNamespaceContext == null) {
            requestNamespaceContext = new HashMap<String, String>();
        }
        requestNamespaceContext.putAll(processor.getNamespaceContext());
        resource.setNamespaceContext(requestNamespaceContext);
        XmlResource xmlResource2 = this._dao.getNode(resource, nodeSelector);
        if (xmlResource2 != null) {
            resource.setCreation(false);
            resource.setSelectedResource(xmlResource2);
            return resource;
        }
        if (!isPut) {
            XcapException e = new XcapException("Resource: " + xcapUri + " not found (no node selected)", 404);
            e.setLevel(Level.INFO);
            throw e;
        }
        String parent = this.locatingParent(resource, nodeSelector, xcapUri.getDocumentSelector(), requestUrlHead);
        resource.setCreation(true);
        String nodeName = nodeSelector.substring(parent.length());
        if (nodeName.indexOf(64) != -1 && nodeName.indexOf(91) == -1) {
            nodeType = XcapResourceImpl.NodeType.ATTRIBUTE;
            nodeName = nodeName.substring(nodeName.indexOf(64) + 1);
        } else {
            nodeType = XcapResourceImpl.NodeType.ELEMENT;
        }
        resource.setParent(parent, nodeType, nodeName);
        return resource;
    }

    private void locatingParent(XcapUri uri, String requestUrlHead) throws XcapException {
        String ancestor = this._dao.getFirstExistAncestor(uri);
        if (uri.hasNodeSeparator() || uri.getDocumentSelector().substring(ancestor.length() + 1).indexOf(47) != -1) {
            XcapException e = new XcapException("parent does not exist", 409);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<no-parent><ancestor>");
            String url = requestUrlHead + this._rootName + ancestor;
            sb.append(RequestUtil.filter(url));
            sb.append("</ancestor></no-parent>");
            sb.append("\n</xcap-error>");
            e.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e;
        }
    }

    private String locatingParent(XcapResource resource, String nodeSelector, String documentSelector, String requestUrlHead) throws XcapException {
        String firstExistAncestor;
        int index = nodeSelector.lastIndexOf(47);
        String parent = nodeSelector.substring(0, index);
        if (!parent.equals(firstExistAncestor = this.getFirstExistNodeAncestor(resource, parent))) {
            XcapException e = new XcapException("parent does not exist", 409);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<no-parent><ancestor>");
            String url = requestUrlHead + this._rootName + documentSelector;
            if (firstExistAncestor != null) {
                url = url + "/~~" + firstExistAncestor;
            }
            sb.append(RequestUtil.filter(url));
            sb.append("</ancestor></no-parent>");
            sb.append("\n</xcap-error>");
            e.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e;
        }
        return parent;
    }

    private String getFirstExistNodeAncestor(XcapResource resource, String nodeSelector) throws XcapException {
        XmlResource xmlResource = this._dao.getNode(resource, nodeSelector);
        if (xmlResource != null) {
            return nodeSelector;
        }
        int index = nodeSelector.lastIndexOf(47);
        if (index != -1) {
            String parent = nodeSelector.substring(0, index);
            return this.getFirstExistNodeAncestor(resource, parent);
        }
        return null;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, SAXException, VerifierConfigurationException {
        String method = request.getMethod();
        String requestUri = request.getRequestURI();
        StringBuffer requestUrl = request.getRequestURL();
        String head = requestUrl.substring(0, requestUrl.indexOf(requestUri));
        try {
            if (POST.equals(method)) {
                throw new XcapException(405);
            }
            Map<String, String> context = this.getXpointer(request);
            XcapUri xcapUri = new XcapUri(requestUri, this._rootName);
            XcapResourceImpl resource = this.getResource(xcapUri, PUT.equals(method), head, context);
            this.ifMatchConditionalProcessing(request, resource);
            this.ifNoneMatchConditionalProcessing(request, resource);
            resource.setAction(method);
            if (method.equals(GET)) {
                this.doGet(response, resource);
            } else if (method.equals(PUT)) {
                this.doPut(request, resource);
            } else if (method.equals(DELETE)) {
                this.doDelete(request, resource);
            }
            if (method.equals(PUT) || method.equals(DELETE)) {
                this.checkIfSameNodeSelected(resource);
                resource.getProcessor().processResource(resource);
                this._dao.save(resource);
                this.notifyResourceChanged(resource);
            }
            String newEtag = this.getEtag(resource);
            resource.setNewEtag(newEtag);
            response.setHeader("Etag", newEtag);
            response.setStatus(200);
            if (this._log.isDebugEnabled()) {
                this._log.debug(method + " " + requestUri + " sucessful");
            }
        }
        catch (XcapException e) {
            if (e.shouldShowStackTrace()) {
                this._log.info("Unable to process " + method + " " + requestUri, (Throwable)e);
            } else {
                this._log.info("Unable to process " + method + " " + requestUri + ": " + e.getMessage());
            }
            e.sendResponse(response);
        }
    }

    private void doGet(HttpServletResponse response, XcapResourceImpl resource) throws IOException {
        response.setContentType(resource.getMimeType());
        if (resource.isAllDocument()) {
            response.getOutputStream().write(resource.getDocument().getBytes());
        } else {
            XmlResource selectedResource = resource.getSelectedResource();
            switch (resource.getNodeType()) {
                case ATTRIBUTE: {
                    response.getOutputStream().write(((Attr)selectedResource.getDom()).getValue().getBytes());
                    break;
                }
                case ELEMENT: {
                    response.getOutputStream().write(selectedResource.getBytes());
                    break;
                }
                case NAMESPACE: {
                    Node node = selectedResource.getDom();
                    String prefix = "<" + node.getNodeName() + " ";
                    response.getOutputStream().write(prefix.getBytes());
                    response.getOutputStream().write(node.getNamespaceURI().getBytes());
                    response.getOutputStream().write("/>".getBytes());
                    break;
                }
            }
        }
    }

    private void doPut(HttpServletRequest request, XcapResourceImpl resource) throws IOException, XcapException, SAXException, VerifierConfigurationException {
        this.throwExceptionIfNamespace(resource);
        String content = this.getContent(request, resource);
        this._dao.update(resource, content);
        if (this._validate) {
            XcapUtil.validate(resource.getDocument().getDom(), resource.getProcessor().getXsdSchema());
        }
        this.validateSpecificAppResource(resource);
    }

    private void doDelete(HttpServletRequest request, XcapResourceImpl resource) throws XcapException, SAXException, VerifierConfigurationException {
        this.throwExceptionIfNamespace(resource);
        this._dao.delete(resource);
        if (!resource.isAllDocument()) {
            if (this._validate) {
                XcapUtil.validate(resource.getDocument().getDom(), resource.getProcessor().getXsdSchema());
            }
            this.validateSpecificAppResource(resource);
        }
    }

    private void validateSpecificAppResource(XcapResourceImpl resource) throws XcapException {
        if (!resource.getProcessor().validateResource(resource)) {
            XcapException e = new XcapException("Specific application resource validation failed", 409);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<constraint-failure/>");
            sb.append("\n</xcap-error>");
            e.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e;
        }
    }

    private void ifMatchConditionalProcessing(HttpServletRequest request, XcapResourceImpl resource) throws XcapException {
        Enumeration ifMatchEnum = request.getHeaders("If-Match");
        String currentEtag = this.getEtag(resource);
        resource.setPreviousEtag(currentEtag);
        if (ifMatchEnum != null && ifMatchEnum.hasMoreElements()) {
            while (ifMatchEnum.hasMoreElements()) {
                String element = (String)ifMatchEnum.nextElement();
                String[] matchEtags = element.split(",");
                for (int i = 0; i < matchEtags.length; ++i) {
                    if ("*".equals(matchEtags[i].trim())) {
                        if (resource.isAllDocument() && resource.isCreation()) {
                            throw new XcapException("Conditional processing failed: If-match: * and new document creation", 412);
                        }
                        if (!this._log.isDebugEnabled()) continue;
                        this._log.debug("wilcard entity tags has matched");
                        continue;
                    }
                    if (!currentEtag.equals(matchEtags[i].trim())) continue;
                    if (this._log.isDebugEnabled()) {
                        this._log.debug("entity tag has matched");
                    }
                    return;
                }
            }
            throw new XcapException("Conditional processing failed: If-match: present and none match", 412);
        }
    }

    private void ifNoneMatchConditionalProcessing(HttpServletRequest request, XcapResourceImpl resource) throws XcapException {
        Enumeration ifNoneMatchEnum = request.getHeaders("If-None-Match");
        if (ifNoneMatchEnum != null && ifNoneMatchEnum.hasMoreElements()) {
            String currentEtag = this.getEtag(resource);
            while (ifNoneMatchEnum.hasMoreElements()) {
                String element = (String)ifNoneMatchEnum.nextElement();
                String[] noneMatchEtags = element.split(",");
                for (int i = 0; i < noneMatchEtags.length; ++i) {
                    if ("*".equals(noneMatchEtags[i].trim())) {
                        if (resource.isAllDocument() && resource.isCreation()) {
                            if (!this._log.isDebugEnabled()) continue;
                            this._log.debug("wilcard entity tag has matched");
                            continue;
                        }
                        throw new XcapException("Conditional processing failed: If-None-match: * and not new document creation", 412);
                    }
                    if (!currentEtag.equals(noneMatchEtags[i].trim())) continue;
                    if (GET.equals(request.getMethod())) {
                        throw new XcapException("Conditional processing failed: If-None-match: present and match", 304);
                    }
                    throw new XcapException("Conditional processing failed: If-None-match: present and match", 412);
                }
            }
        }
    }

    private void throwExceptionIfNamespace(XcapResourceImpl resource) throws XcapException {
        if (!resource.isAllDocument() && resource.getNodeType() == XcapResourceImpl.NodeType.NAMESPACE) {
            XcapException e = new XcapException(405);
            e.addHeader("Allow", GET);
            throw e;
        }
    }

    public String getEtag(XcapResourceImpl resource) {
        try {
            if (resource.getDocument() == null) {
                return "notExist";
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(resource.getDocument().getBytes());
            return HexString.bufferToHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            this._log.error("Unable to initialize Message Digest (for etags).", (Throwable)e);
            return "defaultEtag";
        }
        catch (Throwable e) {
            this._log.error("Unable to to create etags", e);
            return "defaultEtag";
        }
    }

    private String getContent(HttpServletRequest request, XcapResourceImpl resource) throws XcapException {
        if (request.getContentLength() <= 0) {
            throw new XcapException("No content received ", 415);
        }
        if (!resource.getMimeType().equals(request.getContentType())) {
            throw new XcapException("Bad content type: " + request.getContentType() + " should be:" + resource.getMimeType(), 415);
        }
        try {
            int read;
            ServletInputStream is = request.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[128];
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            return new String(new String(os.toByteArray()));
        }
        catch (Throwable e) {
            XcapException e1 = new XcapException("Unable to read content", 409);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<not-xml-att-value/>");
            sb.append("\n</xcap-error>");
            e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e1;
        }
    }

    private Map<String, String> getXpointer(HttpServletRequest request) {
        Enumeration enumeration = request.getParameterNames();
        HashMap<String, String> context = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith(XPOINTER_PREFIX)) continue;
            String prefix = name.substring(XPOINTER_PREFIX.length());
            String[] values = request.getParameter(name).split(XPOINTER_PREFIX_REGEX);
            String ns = values[0].substring(0, values[0].indexOf(41));
            context.put(prefix, ns);
            for (int i = 1; i < values.length; ++i) {
                int index = values[i].indexOf(61);
                prefix = values[i].substring(0, index);
                ns = values[i].substring(index + 1, values[i].indexOf(41));
                context.put(prefix, ns);
            }
        }
        return context;
    }

    private void checkIfSameNodeSelected(XcapResourceImpl resource) throws XcapException {
        if (!resource.getXcapUri().hasNodeSeparator() || resource.isCreation()) {
            return;
        }
        try {
            XmlResource xmlResource = this._dao.getNode(resource);
            boolean valid = false;
            if (xmlResource == null) {
                valid = resource.getAction().equals(DELETE);
            } else {
                Node node = xmlResource.getDom();
                boolean bl = valid = node.equals(resource.getSelectedResource().getDom()) && resource.getAction().equals(PUT);
            }
            if (!valid) {
                XcapException e1 = new XcapException("Request no more select the same node", 409);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
                sb.append("<cannot-insert/>");
                sb.append("\n</xcap-error>");
                e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
                throw e1;
            }
        }
        catch (XcapException e) {
            throw e;
        }
        catch (Throwable e) {
            XcapException e1 = new XcapException("Cannot check if select the same node", 409, e);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n");
            sb.append("<cannot-insert/>");
            sb.append("\n</xcap-error>");
            e1.setContent("application/xcap-error+xml", sb.toString().getBytes());
            throw e1;
        }
    }

    public XcapDao getDao() {
        return this._dao;
    }

    public void setDao(XcapDao dao) {
        this._dao = dao;
    }

    public boolean isValidate() {
        return this._validate;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public boolean isValidateOnGet() {
        return this._validateOnGet;
    }

    public void setValidateOnGet(boolean validateOnGet) {
        this._validateOnGet = validateOnGet;
    }

    public String getRootName() {
        return this._rootName;
    }

    public void setRootName(String name) {
        this._rootName = name == "" || "/".equals(name) ? "/" : (name.startsWith("/") && name.endsWith("/") ? name : "/" + name + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(XcapListener l, XcapUri uri) {
        Map<String, List<XcapListener>> map = this._listeners;
        synchronized (map) {
            List<XcapListener> list = this._listeners.get(uri.getDocumentSelector());
            if (list == null) {
                list = new ArrayList<XcapListener>();
                this._listeners.put(uri.getDocumentSelector(), list);
            }
            if (!list.contains(l)) {
                list.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(XcapListener l, XcapUri uri) {
        Map<String, List<XcapListener>> map = this._listeners;
        synchronized (map) {
            List<XcapListener> list = this._listeners.get(uri.getDocumentSelector());
            if (list != null) {
                list.remove(l);
                if (list.isEmpty()) {
                    this._listeners.remove(uri.getDocumentSelector());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResourceChanged(XcapResource resource) {
        List<XcapListener> list = null;
        Map<String, List<XcapListener>> map = this._listeners;
        synchronized (map) {
            list = this._listeners.get(resource.getXcapUri().getDocumentSelector());
        }
        if (list != null) {
            Iterator<XcapListener> it = list.iterator();
            while (it.hasNext()) {
                it.next().documentChanged(resource);
            }
        }
    }
}

