/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap;

import java.util.Map;
import org.cipango.kaleo.xcap.XcapResource;
import org.cipango.kaleo.xcap.XcapResourceProcessor;
import org.cipango.kaleo.xcap.XcapUri;
import org.cipango.kaleo.xcap.dao.XmlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapResourceImpl
implements XcapResource {
    private XcapUri _xcapUri;
    private XmlResource _selectedResource;
    private String _action;
    private boolean _creation;
    private XcapResourceProcessor _processor;
    private String _previousEtag;
    private String _newEtag;
    private String _parentPath;
    private NodeType _nodeType;
    private String _nodeName;
    private XmlResource _document;
    private Map<String, String> _namespaceContext;

    @Override
    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = action;
    }

    @Override
    public boolean isAllDocument() {
        return !this._xcapUri.hasNodeSeparator();
    }

    @Override
    public String getMimeType() {
        if (this.isAllDocument()) {
            return this._processor.getMimeType();
        }
        return this._nodeType.getMimeType();
    }

    @Override
    public boolean isCreation() {
        return this._creation;
    }

    @Override
    public XcapResourceProcessor getProcessor() {
        return this._processor;
    }

    public void setProcessor(XcapResourceProcessor processor) {
        this._processor = processor;
    }

    public void setCreation(boolean creation) {
        this._creation = creation;
    }

    private void setNodeType(short nodeType) {
        if (this._nodeType == null) {
            if (nodeType == 2) {
                this._nodeType = NodeType.ATTRIBUTE;
            } else if (nodeType == 1) {
                this._nodeType = NodeType.ELEMENT;
            } else if (nodeType == 13) {
                this._nodeType = NodeType.NAMESPACE;
            } else {
                throw new IllegalArgumentException("Invalid node type: " + nodeType);
            }
        }
    }

    public void setSelectedResource(XmlResource resource) {
        this._selectedResource = resource;
        this.setNodeType(this._selectedResource.getDom().getNodeType());
    }

    public void setParent(String parentPath, NodeType nodeType, String nodeName) {
        this._parentPath = parentPath;
        this._nodeType = nodeType;
        this._nodeName = nodeName;
    }

    @Override
    public String getParentPath() {
        return this._parentPath;
    }

    @Override
    public NodeType getNodeType() {
        return this._nodeType;
    }

    @Override
    public String getNodeName() {
        return this._nodeName;
    }

    @Override
    public String getNewEtag() {
        return this._newEtag;
    }

    public void setNewEtag(String newEtag) {
        this._newEtag = newEtag;
    }

    @Override
    public String getPreviousEtag() {
        return this._previousEtag;
    }

    public void setPreviousEtag(String previousEtag) {
        this._previousEtag = previousEtag;
    }

    @Override
    public XmlResource getDocument() {
        return this._document;
    }

    @Override
    public void setDocument(XmlResource resource) {
        this._document = resource;
    }

    @Override
    public XcapUri getXcapUri() {
        return this._xcapUri;
    }

    public void setXcapUri(XcapUri xcapUri) {
        this._xcapUri = xcapUri;
    }

    @Override
    public XmlResource getSelectedResource() {
        if (this.isAllDocument()) {
            return this._document;
        }
        return this._selectedResource;
    }

    @Override
    public Map<String, String> getNamespaceContext() {
        return this._namespaceContext;
    }

    public void setNamespaceContext(Map<String, String> namespaceContext) {
        this._namespaceContext = namespaceContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        ATTRIBUTE("application/xcap-att+xml"),
        ELEMENT("application/xcap-el+xml"),
        NAMESPACE("application/xcap-ns+xml");

        private String _mimeType;

        private NodeType(String mimeType) {
            this._mimeType = mimeType;
        }

        public String getMimeType() {
            return this._mimeType;
        }
    }
}

