/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.xcap;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class XcapException
extends RuntimeException {
    private static final Logger log = Logger.getLogger(XcapException.class);
    public static final String SEPARATOR = "\n";
    public static final String XCAP_ERROR_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xcap-error xmlns=\"urn:ietf:params:xml:ns:xcap-error\">\n";
    public static final String XCAP_ERROR_FOOTER = "\n</xcap-error>";
    public static final String XCAP_ERROR_CONTENT_TYPE = "application/xcap-error+xml";
    private int status;
    private String reason;
    private String headerName;
    private String headerValue;
    private boolean showStackTrace;
    private Level level;
    private String contentType;
    private byte[] content;

    public XcapException(String message, int statusCode, String reasonPhrase, Throwable e, boolean showStackTrace) {
        super(message, e);
        this.status = statusCode;
        this.reason = reasonPhrase;
        this.level = Level.WARN;
        this.showStackTrace = showStackTrace;
    }

    public XcapException(String message, int statusCode, String reasonPhrase, Throwable e) {
        this(message, statusCode, reasonPhrase, e, true);
    }

    public XcapException(String message, int statusCode, String reasonPhrase) {
        this(message, statusCode, reasonPhrase, null, false);
    }

    public XcapException(String message, int statusCode, Throwable e, boolean showStackTrace) {
        this(message, statusCode, null, e, showStackTrace);
    }

    public XcapException(String message, int statusCode, Throwable e) {
        this(message, statusCode, null, e, true);
    }

    public XcapException(String message, int statusCode) {
        this(message, statusCode, null, null, false);
    }

    public XcapException(String message, int statusCode, Level logLevel) {
        this(message, statusCode, null, null, false);
        this.level = logLevel;
    }

    public XcapException(int statusCode, String reasonPhrase) {
        this(statusCode + " " + reasonPhrase, statusCode, reasonPhrase, null, false);
    }

    public XcapException(int statusCode) {
        this(statusCode, null);
    }

    public void addHeader(String name, String value) {
        this.headerName = name;
        this.headerValue = value;
    }

    public int getStatusCode() {
        return this.status;
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public void sendResponse(HttpServletResponse response) {
        try {
            if (this.headerName != null) {
                response.addHeader(this.headerName, this.headerValue);
            }
            if (this.content != null) {
                response.setContentType(this.contentType);
                response.getOutputStream().write(this.content);
                response.getOutputStream().close();
            }
            if (this.reason != null) {
                response.setStatus(this.status, this.reason);
            } else {
                response.setStatus(this.status);
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to send error response", (Throwable)e);
        }
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLogLevel() {
        return this.level;
    }

    public boolean shouldShowStackTrace() {
        return this.showStackTrace;
    }

    public void setContent(String contentType, byte[] content) {
        this.contentType = contentType;
        this.content = content;
    }

    public static XcapException newInternalError(Throwable e) {
        return new XcapException(e.getMessage(), 500, e);
    }
}

