/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence.watcherinfo;

import java.math.BigInteger;
import java.util.List;
import org.cipango.kaleo.event.AbstractEventResource;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.event.Subscription;
import org.cipango.kaleo.event.SubscriptionListener;
import org.cipango.kaleo.presence.Presentity;
import org.cipango.kaleo.presence.watcherinfo.WatcherDocument;
import org.cipango.kaleo.presence.watcherinfo.WatcherListDocument;
import org.cipango.kaleo.presence.watcherinfo.WatcherinfoDocument;

public class WatcherResource
extends AbstractEventResource
implements SubscriptionListener {
    private WatcherinfoDocument _content = WatcherinfoDocument.Factory.newInstance();
    private State _state;

    public WatcherResource(String uri, Presentity presentity) {
        super(uri);
        WatcherinfoDocument.Watcherinfo watcherinfo = this._content.addNewWatcherinfo();
        watcherinfo.setState(WatcherinfoDocument.Watcherinfo.State.FULL);
        watcherinfo.setVersion(BigInteger.ZERO);
        WatcherListDocument.WatcherList list = watcherinfo.addNewWatcherList();
        list.setResource(uri);
        list.setPackage("presence");
        if (presentity != null) {
            List<Subscription> subscriptions = presentity.getSubscriptions();
            for (Subscription subscription : subscriptions) {
                WatcherDocument.Watcher watcher = list.addNewWatcher();
                watcher.setStringValue(subscription.getUri());
                watcher.setId(subscription.getId());
                watcher.setStatus(this.getStatus(subscription.getState()));
                watcher.setEvent(this.getEvent(subscription.getReason()));
            }
        }
        this._state = new State("application/watcherinfo+xml", this._content);
    }

    private void modifyWatcher(Subscription subscription) {
        WatcherListDocument.WatcherList list = this._content.getWatcherinfo().getWatcherListArray(0);
        for (int i = 0; i < list.getWatcherArray().length; ++i) {
            WatcherDocument.Watcher watcher = list.getWatcherArray(i);
            if (!watcher.getStringValue().equals(subscription.getUri())) continue;
            watcher.setStatus(this.getStatus(subscription.getState()));
            watcher.setEvent(this.getEvent(subscription.getReason()));
            return;
        }
        WatcherDocument.Watcher watcher = list.addNewWatcher();
        watcher.setStringValue(subscription.getUri());
        watcher.setId(subscription.getId());
        watcher.setStatus(this.getStatus(subscription.getState()));
        watcher.setEvent(this.getEvent(subscription.getReason()));
    }

    private WatcherDocument.Watcher.Event.Enum getEvent(Subscription.Reason reason) {
        switch (reason) {
            case APPROVED: {
                return WatcherDocument.Watcher.Event.APPROVED;
            }
            case DEACTIVATED: {
                return WatcherDocument.Watcher.Event.DEACTIVATED;
            }
            case GIVEUP: {
                return WatcherDocument.Watcher.Event.GIVEUP;
            }
            case NORESOURCE: {
                return WatcherDocument.Watcher.Event.NORESOURCE;
            }
            case PROBATION: {
                return WatcherDocument.Watcher.Event.PROBATION;
            }
            case REJECTED: {
                return WatcherDocument.Watcher.Event.REJECTED;
            }
            case SUBSCRIBE: {
                return WatcherDocument.Watcher.Event.SUBSCRIBE;
            }
            case TIMEOUT: {
                return WatcherDocument.Watcher.Event.TIMEOUT;
            }
        }
        throw new IllegalStateException("Invalid reason: " + (Object)((Object)reason));
    }

    private WatcherDocument.Watcher.Status.Enum getStatus(Subscription.State state) {
        switch (state) {
            case ACTIVE: {
                return WatcherDocument.Watcher.Status.ACTIVE;
            }
            case PENDING: {
                return WatcherDocument.Watcher.Status.PENDING;
            }
            case WAITING: {
                return WatcherDocument.Watcher.Status.WAITING;
            }
            case TERMINATED: {
                return WatcherDocument.Watcher.Status.TERMINATED;
            }
        }
        throw new IllegalStateException("Invalid state: " + (Object)((Object)state));
    }

    public State getState() {
        return this._state;
    }

    public boolean isDone() {
        return this._content.getWatcherinfo().getWatcherListArray(0).getWatcherArray().length == 0 && !this.hasSubscribers();
    }

    public void subscriptionStateChanged(Subscription subscription, Subscription.State previousState, Subscription.State newState) {
        this.modifyWatcher(subscription);
        this.fireStateChanged();
        if (newState == Subscription.State.TERMINATED) {
            WatcherListDocument.WatcherList list = this._content.getWatcherinfo().getWatcherListArray(0);
            for (int i = 0; i < list.getWatcherArray().length; ++i) {
                WatcherDocument.Watcher watcher = list.getWatcherArray(i);
                if (!watcher.getStringValue().equals(subscription.getUri())) continue;
                list.removeWatcher(i);
                break;
            }
        }
    }

    public State getNeutralState() {
        WatcherinfoDocument document = WatcherinfoDocument.Factory.newInstance();
        WatcherinfoDocument.Watcherinfo watcherinfo = document.addNewWatcherinfo();
        watcherinfo.setState(WatcherinfoDocument.Watcherinfo.State.FULL);
        watcherinfo.setVersion(BigInteger.ZERO);
        WatcherListDocument.WatcherList list = watcherinfo.addNewWatcherList();
        list.setResource(this.getUri());
        list.setPackage("presence");
        return new State("application/watcherinfo+xml", document);
    }
}

