/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence.watcherinfo;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import javax.servlet.sip.SipSession;
import org.cipango.kaleo.event.AbstractEventPackage;
import org.cipango.kaleo.event.ContentHandler;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.event.Subscription;
import org.cipango.kaleo.event.SubscriptionListener;
import org.cipango.kaleo.presence.PresenceEventPackage;
import org.cipango.kaleo.presence.Presentity;
import org.cipango.kaleo.presence.watcherinfo.WatcherResource;
import org.cipango.kaleo.presence.watcherinfo.WatcherinfoDocument;
import org.cipango.kaleo.presence.watcherinfo.WatcherinfoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatcherInfoEventPackage
extends AbstractEventPackage<WatcherResource> {
    public static final String NAME = "presence.winfo";
    public static final String WATCHERINFO = "application/watcherinfo+xml";
    private PresenceEventPackage _presenceEventPackage;
    private WatcherinfoHandler _handler = new WatcherinfoHandler();
    private SubscriptionListener _subscriptionListener = new SubListener();

    public WatcherInfoEventPackage(PresenceEventPackage presence) {
        this._presenceEventPackage = presence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WatcherResource newResource(String uri) {
        Presentity presentity = (Presentity)this._presenceEventPackage.get(uri);
        try {
            WatcherResource watcherResource = new WatcherResource(uri, presentity);
            watcherResource.addListener(this.getEventNotifier());
            WatcherResource watcherResource2 = watcherResource;
            return watcherResource2;
        }
        finally {
            this._presenceEventPackage.put(presentity);
        }
    }

    @Override
    public List<String> getSupportedContentTypes() {
        return Collections.singletonList(WATCHERINFO);
    }

    @Override
    public ContentHandler<?> getContentHandler(String contentType) {
        if (WATCHERINFO.equals(contentType)) {
            return this._handler;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public SubscriptionListener getSubscriptionListener() {
        return this._subscriptionListener;
    }

    @Override
    protected void preprocessState(SipSession session, State state) {
        BigInteger version = (BigInteger)session.getAttribute("version");
        version = version == null ? BigInteger.ZERO : version.add(BigInteger.ONE);
        WatcherinfoDocument.Watcherinfo watcherinfo = ((WatcherinfoDocument)state.getContent()).getWatcherinfo();
        watcherinfo.setVersion(version);
        session.setAttribute("version", (Object)version);
    }

    class SubListener
    implements SubscriptionListener {
        SubListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionStateChanged(Subscription subscription, Subscription.State previousState, Subscription.State newState) {
            WatcherResource resource = (WatcherResource)WatcherInfoEventPackage.this.get(subscription.getResource().getUri());
            try {
                resource.subscriptionStateChanged(subscription, previousState, newState);
            }
            finally {
                WatcherInfoEventPackage.this.put(resource);
            }
        }
    }
}

