/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cipango.kaleo.Resource;
import org.cipango.kaleo.presence.policy.Policy;
import org.cipango.kaleo.presence.policy.PolicyManager;
import org.cipango.kaleo.presence.policy.XcapPolicy;
import org.cipango.kaleo.xcap.XcapService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapPolicyManager
implements PolicyManager {
    private XcapService _xcapService;
    private Map<String, XcapPolicy> _policies = new HashMap<String, XcapPolicy>();

    public XcapPolicyManager(XcapService xcapService) {
        this._xcapService = xcapService;
    }

    @Override
    public PolicyManager.SubHandling getPolicy(String subscriberUri, Resource resource) {
        return this.getPolicy(resource).getPolicy(subscriberUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getPolicy(Resource resource) {
        XcapPolicy policy;
        Map<String, XcapPolicy> map = this._policies;
        synchronized (map) {
            policy = this._policies.get(resource.getUri());
            if (policy == null) {
                policy = new XcapPolicy(resource, this._xcapService);
                this._policies.put(resource.getUri(), policy);
            }
        }
        return policy;
    }

    public Collection<XcapPolicy> getPolicies() {
        return this._policies.values();
    }
}

