/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence.policy;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.cipango.kaleo.Resource;
import org.cipango.kaleo.policy.ConditionsType;
import org.cipango.kaleo.policy.ExtensibleType;
import org.cipango.kaleo.policy.IdentityType;
import org.cipango.kaleo.policy.ManyType;
import org.cipango.kaleo.policy.RuleType;
import org.cipango.kaleo.policy.RulesetDocument;
import org.cipango.kaleo.policy.ValidityType;
import org.cipango.kaleo.policy.oma.ExternalListDocument;
import org.cipango.kaleo.policy.presence.SubHandlingDocument;
import org.cipango.kaleo.presence.policy.Policy;
import org.cipango.kaleo.presence.policy.PolicyListener;
import org.cipango.kaleo.presence.policy.PolicyManager;
import org.cipango.kaleo.xcap.XcapException;
import org.cipango.kaleo.xcap.XcapListener;
import org.cipango.kaleo.xcap.XcapResource;
import org.cipango.kaleo.xcap.XcapResourceImpl;
import org.cipango.kaleo.xcap.XcapService;
import org.cipango.kaleo.xcap.XcapUri;
import org.eclipse.jetty.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapPolicy
implements Policy {
    private static final String OMA_COMMON_POLICY = "urn:oma:xml:xdm:common-policy";
    private static final String PRES_RULES = "urn:ietf:params:xml:ns:pres-rules";
    private static final Logger __log = LoggerFactory.getLogger(XcapPolicy.class);
    private Object _listeners;
    private String _resourceUri;
    private XcapListener _xcapListener;
    private XcapService _xcapService;
    private List<XcapUri> _xcapResources = new ArrayList<XcapUri>();

    public XcapPolicy(Resource resource, XcapService xcapService) {
        this._resourceUri = resource.getUri();
        this._xcapService = xcapService;
        this.addXcapRessource(new XcapUri("org.openmobilealliance.pres-rules", this._resourceUri, "pres-rules", null));
    }

    @Override
    public String getResourceUri() {
        return this._resourceUri;
    }

    private void addXcapRessource(XcapUri xcapUri) {
        XcapUri uri = new XcapUri(xcapUri.getDocumentSelector());
        if (!this._xcapResources.contains(uri)) {
            this._xcapResources.add(uri);
            if (this._listeners != null) {
                this._xcapService.addListener(this._xcapListener, uri);
            }
        }
    }

    @Override
    public PolicyManager.SubHandling getPolicy(String subscriberUri) {
        try {
            PolicyManager.SubHandling subHandling;
            RuleType rule;
            int i;
            XcapUri xcapUri = this._xcapResources.get(0);
            XcapResourceImpl xcapResource = this._xcapService.getResource(xcapUri, false, null, null);
            RulesetDocument.Ruleset ruleset = RulesetDocument.Factory.parse(xcapResource.getSelectedResource().getDom()).getRuleset();
            PolicyManager.SubHandling best = null;
            String domain = null;
            if (subscriberUri.indexOf(64) != -1) {
                domain = subscriberUri.substring(subscriberUri.indexOf(64) + 1);
            }
            for (i = 0; i < ruleset.getRuleArray().length; ++i) {
                rule = ruleset.getRuleArray(i);
                if (!this.match(rule.getConditions(), subscriberUri, domain)) continue;
                subHandling = this.getSubHandling(rule.getActions());
                if (best != null && subHandling.getValue() <= best.getValue()) continue;
                best = subHandling;
            }
            if (best == null) {
                for (i = 0; i < ruleset.getRuleArray().length; ++i) {
                    rule = ruleset.getRuleArray(i);
                    if (!this.matchOma(rule.getConditions(), subscriberUri)) continue;
                    subHandling = this.getSubHandling(rule.getActions());
                    if (best != null && subHandling.getValue() <= best.getValue()) continue;
                    best = subHandling;
                }
            }
            if (best == null) {
                for (i = 0; i < ruleset.getRuleArray().length; ++i) {
                    rule = ruleset.getRuleArray(i);
                    if (!this.matchOmaOtherIdentity(rule.getConditions())) continue;
                    subHandling = this.getSubHandling(rule.getActions());
                    if (best != null && subHandling.getValue() <= best.getValue()) continue;
                    best = subHandling;
                }
            }
            __log.debug("Got policy " + best + " for subscriber {} and resource {}", (Object)subscriberUri, (Object)this._resourceUri);
            if (best == null) {
                return PolicyManager.SubHandling.BLOCK;
            }
            return best;
        }
        catch (XcapException e) {
            __log.debug("Unable to find policy for subcription: " + subscriberUri, (Throwable)e);
            return PolicyManager.SubHandling.BLOCK;
        }
        catch (Exception e) {
            __log.warn("Unable to find policy for subcription: " + subscriberUri, (Throwable)e);
            return PolicyManager.SubHandling.BLOCK;
        }
    }

    private PolicyManager.SubHandling getSubHandling(ExtensibleType actions) {
        XmlCursor cursor = actions.newCursor();
        cursor.toChild(PRES_RULES, "sub-handling");
        SubHandlingDocument.SubHandling subHandling = (SubHandlingDocument.SubHandling)cursor.getObject();
        if (subHandling.enumValue().equals((Object)SubHandlingDocument.SubHandling.ALLOW)) {
            return PolicyManager.SubHandling.ALLOW;
        }
        if (subHandling.enumValue().equals((Object)SubHandlingDocument.SubHandling.CONFIRM)) {
            return PolicyManager.SubHandling.CONFIRM;
        }
        if (subHandling.enumValue().equals((Object)SubHandlingDocument.SubHandling.BLOCK)) {
            return PolicyManager.SubHandling.BLOCK;
        }
        if (subHandling.enumValue().equals((Object)SubHandlingDocument.SubHandling.POLITE_BLOCK)) {
            return PolicyManager.SubHandling.POLITE_BLOCK;
        }
        throw new IllegalArgumentException("No sub-handling block");
    }

    private boolean match(ConditionsType conditions, String subscriberAor, String domain) {
        boolean matchIdentity = conditions.getIdentityArray().length == 0;
        for (int i = 0; i < conditions.getIdentityArray().length; ++i) {
            int j;
            IdentityType identity = conditions.getIdentityArray(i);
            for (j = 0; j < identity.getOneArray().length; ++j) {
                if (!identity.getOneArray(j).getId().equals(subscriberAor)) continue;
                matchIdentity = true;
            }
            for (j = 0; j < identity.getManyArray().length; ++j) {
                ManyType manyType = identity.getManyArray(j);
                if (!manyType.getDomain().equals(domain)) continue;
                boolean match = true;
                for (int k = 0; k < manyType.getExceptArray().length; ++k) {
                    if (!manyType.getExceptArray(k).getId().equals(subscriberAor)) continue;
                    match = false;
                }
                if (!match) continue;
                matchIdentity = true;
            }
        }
        if (!matchIdentity) {
            return false;
        }
        boolean matchValidity = conditions.getValidityArray().length == 0;
        Date now = new Date();
        for (int i = 0; i < conditions.getValidityArray().length; ++i) {
            ValidityType validity = conditions.getValidityArray(i);
            for (int j = 0; j < validity.getFromArray().length; ++j) {
                if (!validity.getFromArray(j).after(now) || !validity.getUntilArray(j).before(now)) continue;
                matchValidity = true;
            }
        }
        if (!matchValidity) {
            return false;
        }
        return conditions.getIdentityArray().length != 0 || conditions.getValidityArray().length != 0;
    }

    private boolean matchOma(ConditionsType conditions, String subscriberAor) {
        try {
            XmlCursor cursor = conditions.newCursor();
            cursor.push();
            if (cursor.toChild(OMA_COMMON_POLICY, "external-list")) {
                ExternalListDocument.ExternalList list = (ExternalListDocument.ExternalList)cursor.getObject();
                for (int i = 0; i < list.getEntryArray().length; ++i) {
                    String anchor = list.getEntryArray(i).getAnc();
                    if (!this.match(anchor, subscriberAor)) continue;
                    return true;
                }
            }
            cursor.pop();
            if (cursor.toChild(OMA_COMMON_POLICY, "anonymous-request")) {
                return subscriberAor.equals("sip:anonymous@anonymous.invalid");
            }
        }
        catch (Throwable e) {
            __log.warn("Unable to check OMA conditions for subscriber " + subscriberAor, e);
        }
        return false;
    }

    private boolean match(String anchor, String subscriberAor) {
        int index = anchor.indexOf("://");
        String uri = anchor.substring(anchor.indexOf(this._xcapService.getRootName(), index + 3));
        XcapUri xcapUri = new XcapUri(uri, this._xcapService.getRootName());
        this.addXcapRessource(xcapUri);
        XcapResourceImpl xcapResource = this._xcapService.getResource(xcapUri, false, null, null);
        NodeList nodes = xcapResource.getSelectedResource().getDom().getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element element;
            Node node = nodes.item(j);
            if (!("entry".equals(node.getLocalName()) ? subscriberAor.equals((element = (Element)node).getAttribute("uri")) : "external".equals(node.getLocalName()) && this.match(anchor = (element = (Element)node).getAttribute("anchor"), subscriberAor))) continue;
            return true;
        }
        return false;
    }

    private boolean matchOmaOtherIdentity(ConditionsType conditions) {
        XmlCursor cursor = conditions.newCursor();
        return cursor.toChild(OMA_COMMON_POLICY, "other-identity");
    }

    @Override
    public void addListener(PolicyListener l) {
        if (!LazyList.contains((Object)this._listeners, (Object)l)) {
            this._listeners = LazyList.add((Object)this._listeners, (Object)l);
        }
        if (this._xcapListener == null) {
            this._xcapListener = new XcapListenerImpl();
            Iterator<XcapUri> it = this._xcapResources.iterator();
            while (it.hasNext()) {
                this._xcapService.addListener(this._xcapListener, it.next());
            }
        }
    }

    @Override
    public void removeListener(PolicyListener l) {
        this._listeners = LazyList.remove((Object)this._listeners, (Object)l);
        if (this._listeners == null && this._xcapListener != null) {
            Iterator<XcapUri> it = this._xcapResources.iterator();
            while (it.hasNext()) {
                this._xcapService.removeListener(this._xcapListener, it.next());
            }
            this._xcapListener = null;
        }
    }

    public List<XcapUri> getXcapResources() {
        return this._xcapResources;
    }

    class XcapListenerImpl
    implements XcapListener {
        XcapListenerImpl() {
        }

        public void documentChanged(XcapResource resource) {
            __log.debug("Policy for resource " + XcapPolicy.this._resourceUri + " has changed");
            for (int i = 0; i < LazyList.size((Object)XcapPolicy.this._listeners); ++i) {
                ((PolicyListener)LazyList.get((Object)XcapPolicy.this._listeners, (int)i)).policyHasChanged(XcapPolicy.this);
            }
        }
    }
}

