/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.cipango.kaleo.event.AbstractEventResource;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.presence.SoftState;
import org.cipango.kaleo.presence.pidf.Basic;
import org.cipango.kaleo.presence.pidf.Presence;
import org.cipango.kaleo.presence.pidf.PresenceDocument;
import org.cipango.kaleo.presence.pidf.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Presentity
extends AbstractEventResource {
    private static Random __random = new Random();
    private static Logger __log = LoggerFactory.getLogger(Presentity.class);
    private List<SoftState> _states = new ArrayList<SoftState>();

    public static synchronized String newETag() {
        return Integer.toString(Math.abs(__random.nextInt()), 36);
    }

    public Presentity(String uri) {
        super(uri);
    }

    public boolean isDone() {
        return this._states.size() == 0 && !this.hasSubscribers();
    }

    public void doTimeout(long time) {
        super.doTimeout(time);
        boolean stateRemoved = false;
        Iterator<SoftState> it = this._states.iterator();
        while (it.hasNext()) {
            SoftState state = it.next();
            if (state.getExpirationTime() > time) continue;
            it.remove();
            stateRemoved = true;
        }
        if (stateRemoved) {
            this.fireStateChanged();
        }
    }

    public long nextTimeout() {
        long next = super.nextTimeout();
        for (SoftState state : this._states) {
            long time = state.getExpirationTime();
            if (time <= 0L || time >= next && next >= 0L) continue;
            next = time;
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftState addState(String contentType, Object content, long expirationTime) {
        SoftState state = new SoftState(contentType, content, Presentity.newETag(), expirationTime);
        List<SoftState> list = this._states;
        synchronized (list) {
            this._states.add(state);
        }
        this.fireStateChanged();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftState getState(String etag) {
        List<SoftState> list = this._states;
        synchronized (list) {
            for (SoftState state : this._states) {
                if (!state.getETag().equals(etag)) continue;
                return state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeState(String etag) {
        List<SoftState> list = this._states;
        synchronized (list) {
            for (int i = 0; i < this._states.size(); ++i) {
                SoftState state = this._states.get(i);
                if (!state.getETag().equals(etag)) continue;
                this._states.remove(i);
            }
        }
        this.fireStateChanged();
    }

    public void modifyState(SoftState state, String contentType, Object content, long expirationTime) {
        state.setContent(contentType, content);
        state.setETag(Presentity.newETag());
        state.setExpirationTime(expirationTime);
        this.fireStateChanged();
    }

    public void refreshState(SoftState state, long expirationTime) {
        state.setETag(Presentity.newETag());
        state.setExpirationTime(expirationTime);
    }

    public State getNeutralState() {
        PresenceDocument document = PresenceDocument.Factory.newInstance();
        Presence presence = document.addNewPresence();
        presence.setEntity(this.getUri());
        Tuple tuple = document.getPresence().addNewTuple();
        tuple.setId("123");
        tuple.addNewStatus().setBasic(Basic.CLOSED);
        return new State("application/pidf+xml", document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State getCurrentState() {
        List<SoftState> list = this._states;
        synchronized (list) {
            if (this._states.size() == 0) {
                return null;
            }
            if (this._states.size() == 1) {
                return this._states.get(0);
            }
            XmlCursor cursor = null;
            String contentType = null;
            HashMap namespaces = new HashMap();
            for (SoftState state : this._states) {
                XmlObject o = (XmlObject)state.getContent();
                if (cursor == null) {
                    cursor = o.copy().newCursor();
                    cursor.push();
                    cursor.toFirstChild();
                    cursor.toEndToken();
                    contentType = state.getContentType();
                    continue;
                }
                XmlCursor cursor2 = o.newCursor();
                cursor2.toFirstChild();
                cursor2.toFirstChild();
                cursor2.getAllNamespaces(namespaces);
                do {
                    this.add(cursor2, cursor);
                } while (cursor2.toNextSibling());
                cursor2.dispose();
            }
            cursor.toParent();
            cursor.toLastAttribute();
            for (String name : namespaces.keySet()) {
                cursor.insertNamespace(name, (String)namespaces.get(name));
            }
            cursor.pop();
            XmlObject o = cursor.getObject();
            cursor.dispose();
            return new State(contentType, o);
        }
    }

    private void add(XmlCursor source, XmlCursor destination) {
        NodeList nodeList = destination.getDomNode().getChildNodes();
        Attr idNode = (Attr)source.getDomNode().getAttributes().getNamedItem("id");
        if (idNode != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                Attr idNode2 = (Attr)(node2.getAttributes() != null ? node2.getAttributes().getNamedItem("id") : null);
                if (!node2.getNodeName().equals(source.getDomNode().getNodeName()) || idNode2 == null || !idNode.getValue().equals(idNode2.getValue())) continue;
                __log.warn("Got two nodes with same id: {}. Ignore second node.", (Object)idNode.getValue());
                return;
            }
        }
        source.copyXml(destination);
    }

    public State getState() {
        if (this._states.isEmpty()) {
            return this.getNeutralState();
        }
        return this.getCurrentState();
    }

    public String toString() {
        return this.getUri();
    }
}

