/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.presence;

import java.util.Collections;
import java.util.List;
import org.cipango.kaleo.event.AbstractEventPackage;
import org.cipango.kaleo.event.ContentHandler;
import org.cipango.kaleo.event.Subscription;
import org.cipango.kaleo.presence.Presentity;
import org.cipango.kaleo.presence.pidf.PidfHandler;
import org.cipango.kaleo.presence.policy.Policy;
import org.cipango.kaleo.presence.policy.PolicyListener;
import org.cipango.kaleo.presence.policy.PolicyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceEventPackage
extends AbstractEventPackage<Presentity> {
    public Logger _log = LoggerFactory.getLogger(PresenceEventPackage.class);
    public static final String NAME = "presence";
    public static final String PIDF = "application/pidf+xml";
    private PidfHandler _pidfHandler = new PidfHandler();
    public int _minStateExpires = 1;
    public int _maxStateExpires = 3600;
    public int _defaultStateExpires = 3600;
    private PolicyListener _policyListener = new PolicyUpdater();
    private PolicyManager _policyManager;

    @Override
    public String getName() {
        return NAME;
    }

    public int getMinStateExpires() {
        return this._minStateExpires;
    }

    public int getMaxStateExpires() {
        return this._maxStateExpires;
    }

    public int getDefaultStateExpires() {
        return this._defaultStateExpires;
    }

    @Override
    protected Presentity newResource(String uri) {
        Presentity presentity = new Presentity(uri);
        presentity.addListener(this.getEventNotifier());
        Policy policy = this._policyManager.getPolicy(presentity);
        policy.addListener(this._policyListener);
        return presentity;
    }

    @Override
    protected void removeResource(Presentity presentity) {
        super.removeResource(presentity);
        Policy policy = this._policyManager.getPolicy(presentity);
        policy.removeListener(this._policyListener);
    }

    @Override
    public List<String> getSupportedContentTypes() {
        return Collections.singletonList(PIDF);
    }

    @Override
    public ContentHandler<?> getContentHandler(String contentType) {
        if (PIDF.equals(contentType)) {
            return this._pidfHandler;
        }
        return null;
    }

    public PolicyListener getPolicyListener() {
        return this._policyListener;
    }

    public PolicyManager getPolicyManager() {
        return this._policyManager;
    }

    public void setPolicyManager(PolicyManager policyManager) {
        this._policyManager = policyManager;
    }

    class PolicyUpdater
    implements PolicyListener {
        PolicyUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void policyHasChanged(Policy policy) {
            Presentity presentity = (Presentity)PresenceEventPackage.this.get(policy.getResourceUri());
            try {
                for (Subscription subscription : presentity.getSubscriptions()) {
                    PolicyManager.SubHandling subHandling = policy.getPolicy(subscription.getUri());
                    Subscription.State state = subscription.getState();
                    boolean authorised = subscription.isAuthorized();
                    switch (subHandling) {
                        case ALLOW: {
                            subscription.setState(Subscription.State.ACTIVE, Subscription.Reason.APPROVED, true);
                            break;
                        }
                        case CONFIRM: {
                            subscription.setState(Subscription.State.PENDING, Subscription.Reason.SUBSCRIBE, true);
                            break;
                        }
                        case POLITE_BLOCK: {
                            subscription.setState(Subscription.State.ACTIVE, Subscription.Reason.SUBSCRIBE, false);
                            break;
                        }
                        case BLOCK: {
                            subscription.setState(Subscription.State.TERMINATED, Subscription.Reason.REJECTED, false);
                            break;
                        }
                    }
                    if (state == subscription.getState() && authorised == subscription.isAuthorized()) continue;
                    PresenceEventPackage.this.notify(subscription);
                }
            }
            finally {
                PresenceEventPackage.this.put(presentity);
            }
        }
    }
}

