/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.location.event;

import java.math.BigInteger;
import org.cipango.kaleo.event.AbstractEventResource;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.location.Binding;
import org.cipango.kaleo.location.Registration;
import org.cipango.kaleo.location.RegistrationListener;
import org.cipango.kaleo.location.event.ContactDocument;
import org.cipango.kaleo.location.event.ReginfoDocument;
import org.cipango.kaleo.location.event.RegistrationDocument;

public class RegResource
extends AbstractEventResource
implements RegistrationListener {
    private ReginfoDocument _content = ReginfoDocument.Factory.newInstance();
    private State _state;

    public RegResource(String uri, Registration registration) {
        super(uri);
        ReginfoDocument.Reginfo reginfo = this._content.addNewReginfo();
        reginfo.setVersion(BigInteger.ZERO);
        reginfo.setState(ReginfoDocument.Reginfo.State.FULL);
        RegistrationDocument.Registration reg = reginfo.addNewRegistration();
        reg.setAor(uri);
        reg.setId("123");
        if (registration != null && !registration.getBindings().isEmpty()) {
            reg.setState(RegistrationDocument.Registration.State.ACTIVE);
            for (Binding binding : registration.getBindings()) {
                ContactDocument.Contact contact = reg.addNewContact();
                contact.setUri(binding.getContact().toString());
                contact.setEvent(ContactDocument.Contact.Event.REGISTERED);
                contact.setId(String.valueOf(binding.getId()));
                contact.setCallid(binding.getCallId());
                contact.setCseq(BigInteger.valueOf(binding.getCSeq()));
                contact.setExpires(BigInteger.valueOf(binding.getExpires()));
            }
        } else {
            reg.setState(RegistrationDocument.Registration.State.INIT);
        }
        this._state = new State("application/reginfo+xml", this._content);
    }

    public State getState() {
        return this._state;
    }

    public boolean isDone() {
        return this._content.getReginfo().getRegistrationArray(0).getContactArray().length == 0 && !this.hasSubscribers();
    }

    public void bindingChanged(String aor, Binding binding, ContactDocument.Contact.Event.Enum event, RegistrationDocument.Registration.State.Enum state) {
        ContactDocument.Contact contactModified = null;
        RegistrationDocument.Registration registration = this._content.getReginfo().getRegistrationArray(0);
        registration.setState(state);
        for (ContactDocument.Contact contact : registration.getContactArray()) {
            if (!contact.getId().equals(String.valueOf(binding.getId()))) continue;
            contactModified = contact;
        }
        if (contactModified == null) {
            contactModified = registration.addNewContact();
        }
        contactModified.setUri(binding.getContact().toString());
        contactModified.setEvent(event);
        contactModified.setId(String.valueOf(binding.getId()));
        contactModified.setCallid(binding.getCallId());
        contactModified.setCseq(BigInteger.valueOf(binding.getCSeq()));
        contactModified.setExpires(BigInteger.valueOf(binding.getExpires()));
        this.fireStateChanged();
        if (event == ContactDocument.Contact.Event.DEACTIVATED || event == ContactDocument.Contact.Event.EXPIRED || event == ContactDocument.Contact.Event.UNREGISTERED || event == ContactDocument.Contact.Event.REJECTED) {
            for (int i = 0; i < registration.getContactArray().length; ++i) {
                if (registration.getContactArray(i) != contactModified) continue;
                registration.removeContact(i);
                break;
            }
        }
    }

    public void allBindingsRemoved(String aor) {
        RegistrationDocument.Registration registration = this._content.getReginfo().getRegistrationArray(0);
        registration.setState(RegistrationDocument.Registration.State.TERMINATED);
        for (ContactDocument.Contact contact : registration.getContactArray()) {
            contact.setEvent(ContactDocument.Contact.Event.UNREGISTERED);
        }
        this.fireStateChanged();
        this._content.getReginfo().setVersion(this._content.getReginfo().getVersion().add(BigInteger.ONE));
        while (registration.getContactArray().length != 0) {
            registration.removeContact(0);
        }
    }

    public State getNeutralState() {
        ReginfoDocument document = ReginfoDocument.Factory.newInstance();
        ReginfoDocument.Reginfo reginfo = document.addNewReginfo();
        reginfo.setVersion(BigInteger.ZERO);
        reginfo.setState(ReginfoDocument.Reginfo.State.FULL);
        RegistrationDocument.Registration reg = reginfo.addNewRegistration();
        reg.setAor(this.getUri());
        reg.setId("123");
        return new State("application/reginfo+xml", document);
    }
}

