/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.location.event;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import javax.servlet.sip.SipSession;
import org.cipango.kaleo.event.AbstractEventPackage;
import org.cipango.kaleo.event.ContentHandler;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.location.Binding;
import org.cipango.kaleo.location.LocationService;
import org.cipango.kaleo.location.Registration;
import org.cipango.kaleo.location.RegistrationListener;
import org.cipango.kaleo.location.event.ContactDocument;
import org.cipango.kaleo.location.event.RegResource;
import org.cipango.kaleo.location.event.ReginfoDocument;
import org.cipango.kaleo.location.event.ReginfoHandler;
import org.cipango.kaleo.location.event.RegistrationDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegEventPackage
extends AbstractEventPackage<RegResource> {
    public static final String NAME = "reg";
    public static final String REGINFO = "application/reginfo+xml";
    private ReginfoHandler _handler = new ReginfoHandler();
    private RegistrationListener _registrationListener = new RegListener();
    private LocationService _locationService;

    public RegEventPackage(LocationService locationService) {
        this._locationService = locationService;
    }

    @Override
    public ContentHandler<?> getContentHandler(String contentType) {
        if (REGINFO.equals(contentType)) {
            return this._handler;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RegResource newResource(String uri) {
        Registration registration = (Registration)this._locationService.get(uri);
        try {
            RegResource regResource = new RegResource(uri, registration);
            regResource.addListener(this.getEventNotifier());
            RegResource regResource2 = regResource;
            return regResource2;
        }
        finally {
            this._locationService.put(registration);
        }
    }

    @Override
    public List<String> getSupportedContentTypes() {
        return Collections.singletonList(REGINFO);
    }

    public RegistrationListener getRegistrationListener() {
        return this._registrationListener;
    }

    @Override
    protected void preprocessState(SipSession session, State state) {
        BigInteger version = (BigInteger)session.getAttribute("version");
        version = version == null ? BigInteger.ZERO : version.add(BigInteger.ONE);
        ReginfoDocument.Reginfo reginfo = ((ReginfoDocument)state.getContent()).getReginfo();
        reginfo.setVersion(version);
        session.setAttribute("version", (Object)version);
    }

    class RegListener
    implements RegistrationListener {
        RegListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allBindingsRemoved(String aor) {
            RegResource resource = (RegResource)RegEventPackage.this.get(aor);
            try {
                resource.allBindingsRemoved(aor);
            }
            finally {
                RegEventPackage.this.put(resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bindingChanged(String aor, Binding binding, ContactDocument.Contact.Event.Enum event, RegistrationDocument.Registration.State.Enum state) {
            RegResource resource = (RegResource)RegEventPackage.this.get(aor);
            try {
                resource.bindingChanged(aor, binding, event, state);
            }
            finally {
                RegEventPackage.this.put(resource);
            }
        }
    }
}

