/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.location;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.sip.URI;
import org.cipango.kaleo.AbstractResource;
import org.cipango.kaleo.location.Binding;
import org.cipango.kaleo.location.RegistrationListener;
import org.cipango.kaleo.location.event.ContactDocument;
import org.cipango.kaleo.location.event.RegistrationDocument;
import org.eclipse.jetty.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registration
extends AbstractResource {
    private List<Binding> _bindings = new ArrayList<Binding>(1);
    private Object _listeners;

    public Registration(String aor) {
        super(aor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinding(Binding binding) {
        List<Binding> list = this._bindings;
        synchronized (list) {
            this._bindings.add(binding);
        }
        this.fireBindingChanged(binding, ContactDocument.Contact.Event.REGISTERED);
    }

    public void updateBinding(Binding binding, URI contact, String callId, int cseq, long expirationTime) {
        ContactDocument.Contact.Event.Enum event = binding.getExpirationTime() < expirationTime ? ContactDocument.Contact.Event.REFRESHED : ContactDocument.Contact.Event.SHORTENED;
        binding.update(contact, callId, cseq, expirationTime);
        this.fireBindingChanged(binding, event);
    }

    public List<Binding> getBindings() {
        return this._bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinding(Binding binding) {
        List<Binding> list = this._bindings;
        synchronized (list) {
            binding.update(binding.getContact(), binding.getCallId(), binding.getCSeq(), System.currentTimeMillis());
            this._bindings.remove(binding);
        }
        this.fireBindingChanged(binding, ContactDocument.Contact.Event.UNREGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBindings() {
        List<Binding> list = this._bindings;
        synchronized (list) {
            this._bindings.clear();
        }
        for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
            ((RegistrationListener)LazyList.get((Object)this._listeners, (int)i)).allBindingsRemoved(this.getUri());
        }
    }

    @Override
    public boolean isDone() {
        return this._bindings.isEmpty();
    }

    @Override
    public long nextTimeout() {
        if (this._bindings.size() == 0) {
            return -1L;
        }
        long time = Long.MAX_VALUE;
        for (Binding binding : this._bindings) {
            if (binding.getExpirationTime() >= time) continue;
            time = binding.getExpirationTime();
        }
        return time;
    }

    private void fireBindingChanged(Binding binding, ContactDocument.Contact.Event.Enum event) {
        RegistrationDocument.Registration.State.Enum state = this._bindings.isEmpty() ? RegistrationDocument.Registration.State.TERMINATED : RegistrationDocument.Registration.State.ACTIVE;
        for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
            ((RegistrationListener)LazyList.get((Object)this._listeners, (int)i)).bindingChanged(this.getUri(), binding, event, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTimeout(long time) {
        ArrayList<Binding> expired = new ArrayList<Binding>();
        List<Binding> list = this._bindings;
        synchronized (list) {
            Iterator<Binding> it = this._bindings.iterator();
            while (it.hasNext()) {
                Binding binding = it.next();
                if (binding.getExpirationTime() > time) continue;
                it.remove();
                expired.add(binding);
            }
        }
    }

    public void addListener(RegistrationListener l) {
        if (!LazyList.contains((Object)this._listeners, (Object)l) && l != null) {
            this._listeners = LazyList.add((Object)this._listeners, (Object)l);
        }
    }

    public void removeListener(RegistrationListener l) {
        this._listeners = LazyList.remove((Object)this._listeners, (Object)l);
    }
}

