/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.location;

import javax.servlet.sip.URI;

public class Binding {
    private static long __id = 0L;
    private long _id = Binding.newId();
    private String _callId;
    private int _cseq;
    private URI _contact;
    private long _expirationTime;

    public static synchronized long newId() {
        return __id++;
    }

    public Binding(URI contact, String callId, int cseq, long expirationTime) {
        this.update(contact, callId, cseq, expirationTime);
    }

    protected void update(URI contact, String callId, int cseq, long expirationTime) {
        this._contact = contact;
        this._callId = callId;
        this._cseq = cseq;
        this._expirationTime = expirationTime;
    }

    public URI getContact() {
        return this._contact;
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public int getExpires() {
        int expires = (int)((this._expirationTime - System.currentTimeMillis()) / 1000L);
        if (expires < 0) {
            return 0;
        }
        return expires;
    }

    public String getCallId() {
        return this._callId;
    }

    public int getCSeq() {
        return this._cseq;
    }

    public long getId() {
        return this._id;
    }

    public String toString() {
        return this._contact.toString();
    }
}

