/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.event;

import javax.servlet.sip.SipSession;
import org.cipango.kaleo.event.EventResource;
import org.cipango.kaleo.event.SubscriptionListener;
import org.eclipse.jetty.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription {
    private static Logger __log = LoggerFactory.getLogger(Subscription.class);
    private EventResource _resource;
    private SipSession _session;
    private State _state = State.INIT;
    private Reason _reason;
    private long _expirationTime;
    private String _subscriberUri;
    private boolean _authorised = true;
    private Object _listeners;

    public Subscription(EventResource resource, SipSession session, long expirationTime) {
        this._resource = resource;
        this._session = session;
        this._expirationTime = expirationTime;
    }

    public Subscription(EventResource resource, SipSession session, long expirationTime, String subscriberUri) {
        this._resource = resource;
        this._session = session;
        this._expirationTime = expirationTime;
        this._subscriberUri = subscriberUri;
    }

    public void setExpirationTime(long expirationTime) {
        this._expirationTime = expirationTime;
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public String getId() {
        if (this._session == null) {
            return String.valueOf(this.hashCode());
        }
        return this._session.getId();
    }

    public EventResource getResource() {
        return this._resource;
    }

    public SipSession getSession() {
        return this._session;
    }

    public State getState() {
        return this._state;
    }

    public void setState(State state, Reason reason, boolean authorised) {
        State previousState = this._state;
        boolean previousAuthorised = this._authorised;
        this._authorised = authorised;
        this._state = state;
        this._reason = reason;
        if (previousState != state || previousAuthorised != authorised) {
            if (__log.isDebugEnabled()) {
                if (previousState != state) {
                    __log.debug("State changed from {} to {} for " + this, (Object)previousState, (Object)state);
                }
                if (previousAuthorised != authorised) {
                    __log.debug("Authorization changed from {} to {} for " + this, (Object)previousAuthorised, (Object)authorised);
                }
            }
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                ((SubscriptionListener)LazyList.get((Object)this._listeners, (int)i)).subscriptionStateChanged(this, previousState, state);
            }
        }
    }

    public void setState(State state, Reason reason) {
        this.setState(state, reason, this.isAuthorized());
    }

    public Reason getReason() {
        return this._reason;
    }

    public String getUri() {
        return this._subscriberUri;
    }

    public String toString() {
        return this._resource.getUri() + "/" + this.getId();
    }

    public void addListener(SubscriptionListener l) {
        if (!LazyList.contains((Object)this._listeners, (Object)l) && l != null) {
            this._listeners = LazyList.add((Object)this._listeners, (Object)l);
        }
    }

    public void removeListener(SubscriptionListener l) {
        this._listeners = LazyList.remove((Object)this._listeners, (Object)l);
    }

    public boolean isAuthorized() {
        return this._authorised;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        DEACTIVATED("deactivated"),
        PROBATION("probation"),
        REJECTED("rejected"),
        TIMEOUT("timeout"),
        GIVEUP("giveup"),
        NORESOURCE("noresource"),
        SUBSCRIBE("subscribe"),
        APPROVED("approved");

        private String _name;

        private Reason(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INIT("init"),
        ACTIVE("active"),
        PENDING("pending"),
        WAITING("waiting"),
        TERMINATED("terminated");

        private String _name;

        private State(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

