/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cipango.kaleo.AbstractResource;
import org.cipango.kaleo.event.EventResource;
import org.cipango.kaleo.event.EventResourceListener;
import org.cipango.kaleo.event.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventResource
extends AbstractResource
implements EventResource {
    private static final Logger __log = LoggerFactory.getLogger(AbstractEventResource.class);
    private Map<String, Subscription> _subscriptions = new HashMap<String, Subscription>();
    private List<EventResourceListener> _listeners = new ArrayList<EventResourceListener>();

    public AbstractEventResource(String uri) {
        super(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EventResourceListener listener) {
        List<EventResourceListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventResourceListener> getListeners() {
        List<EventResourceListener> list = this._listeners;
        synchronized (list) {
            return new ArrayList<EventResourceListener>(this._listeners);
        }
    }

    protected void fireStateChanged() {
        for (EventResourceListener listener : this._listeners) {
            listener.stateChanged(this);
        }
    }

    protected void fireSubscriptionExpired(Subscription subscription) {
        for (EventResourceListener listener : this._listeners) {
            listener.subscriptionExpired(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(Subscription subscription) {
        Map<String, Subscription> map = this._subscriptions;
        synchronized (map) {
            this._subscriptions.put(subscription.getId(), subscription);
        }
        __log.debug("Add subscription {} to resource {}", (Object)subscription, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getSubscriptions() {
        Map<String, Subscription> map = this._subscriptions;
        synchronized (map) {
            return new ArrayList<Subscription>(this._subscriptions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription getSubscription(String id) {
        Map<String, Subscription> map = this._subscriptions;
        synchronized (map) {
            return this._subscriptions.get(id);
        }
    }

    public void refreshSubscription(String id, int expires) {
    }

    public boolean hasSubscribers() {
        return this._subscriptions.size() != 0;
    }

    @Override
    public long nextTimeout() {
        long next = -1L;
        for (Subscription subscription : this._subscriptions.values()) {
            long time = subscription.getExpirationTime();
            if (time <= 0L || time >= next && next >= 0L) continue;
            next = time;
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription removeSubscription(String id) {
        Subscription subscription = null;
        Map<String, Subscription> map = this._subscriptions;
        synchronized (map) {
            subscription = this._subscriptions.remove(id);
        }
        if (subscription != null) {
            __log.debug("Remove subscription {} to resource {}", (Object)subscription, (Object)this);
        }
        return subscription;
    }

    @Override
    public void doTimeout(long time) {
        Iterator<Subscription> it = this._subscriptions.values().iterator();
        while (it.hasNext()) {
            Subscription subscription = it.next();
            if (subscription.getExpirationTime() > time) continue;
            it.remove();
            this.fireSubscriptionExpired(subscription);
        }
    }
}

