/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo.event;

import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import org.cipango.kaleo.AbstractResource;
import org.cipango.kaleo.AbstractResourceManager;
import org.cipango.kaleo.event.ContentHandler;
import org.cipango.kaleo.event.EventPackage;
import org.cipango.kaleo.event.EventResource;
import org.cipango.kaleo.event.EventResourceListener;
import org.cipango.kaleo.event.State;
import org.cipango.kaleo.event.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventPackage<T extends AbstractResource>
extends AbstractResourceManager<T>
implements EventPackage<T> {
    private int _minExpires = 60;
    private int _maxExpires = 3600;
    private int _defaultExpires = 3600;
    private EventNotifier _eventNotifier = new EventNotifier();

    @Override
    public int getMinExpires() {
        return this._minExpires;
    }

    @Override
    public int getMaxExpires() {
        return this._maxExpires;
    }

    @Override
    public int getDefaultExpires() {
        return this._defaultExpires;
    }

    public void setMinExpires(int minExpires) {
        this._minExpires = minExpires;
    }

    public void setMaxExpires(int maxExpires) {
        this._maxExpires = maxExpires;
    }

    public void setDefaultExpires(int defaultExpires) {
        this._defaultExpires = defaultExpires;
    }

    protected EventResourceListener getEventNotifier() {
        return this._eventNotifier;
    }

    public void notify(Subscription subscription) {
        try {
            SipSession session = subscription.getSession();
            if (session.isValid()) {
                SipServletRequest notify = session.createRequest("NOTIFY");
                notify.addHeader("Event", this.getName());
                String s = subscription.getState().getName();
                if (subscription.getState() == Subscription.State.ACTIVE || subscription.getState() == Subscription.State.PENDING) {
                    s = s + ";expires=" + (subscription.getExpirationTime() - System.currentTimeMillis()) / 1000L;
                }
                notify.addHeader("Subscription-State", s);
                State state = subscription.isAuthorized() ? subscription.getResource().getState() : subscription.getResource().getNeutralState();
                this.preprocessState(session, state);
                ContentHandler handler = this.getContentHandler(state.getContentType());
                byte[] b = handler.getBytes(state.getContent());
                notify.setContent((Object)b, state.getContentType());
                notify.send();
            } else {
                this._log.warn("Could not send notification to {} for event {} as sip session is invalidated", (Object)subscription, (Object)this.getName());
            }
        }
        catch (Exception e) {
            this._log.warn("Exception while sending notification {}", (Throwable)e);
        }
    }

    protected void preprocessState(SipSession session, State state) {
    }

    class EventNotifier
    implements EventResourceListener {
        EventNotifier() {
        }

        public void stateChanged(EventResource resource) {
            if (AbstractEventPackage.this._log.isDebugEnabled()) {
                AbstractEventPackage.this._log.debug("State changed for {} resource {} ", (Object)AbstractEventPackage.this.getName(), (Object)resource);
            }
            for (Subscription subscription : resource.getSubscriptions()) {
                if (!subscription.isAuthorized()) continue;
                AbstractEventPackage.this.notify(subscription);
            }
        }

        public void subscriptionExpired(Subscription subscription) {
            if (subscription.getState() == Subscription.State.PENDING) {
                subscription.setState(Subscription.State.WAITING, Subscription.Reason.TIMEOUT);
            } else {
                subscription.setState(Subscription.State.TERMINATED, Subscription.Reason.TIMEOUT);
            }
            AbstractEventPackage.this.notify(subscription);
        }
    }
}

