/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.kaleo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.cipango.kaleo.AbstractResource;
import org.cipango.util.PriorityQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceManager<T extends AbstractResource>
extends AbstractLifeCycle {
    private Thread _scheduler;
    private PriorityQueue _queue = new PriorityQueue();
    private Map<String, ResourceHolder> _resources = new HashMap<String, ResourceHolder>();
    protected Logger _log = LoggerFactory.getLogger(AbstractResourceManager.class);

    protected void doStart() throws Exception {
        new Thread(new Scheduler()).start();
    }

    protected void doStop() throws Exception {
        if (this._scheduler != null) {
            this._scheduler.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getResources() {
        ArrayList resources = new ArrayList();
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            Iterator<ResourceHolder> it = this._resources.values().iterator();
            while (it.hasNext()) {
                resources.add(it.next().getResource());
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceHolder> getHolders() {
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            return new ArrayList<ResourceHolder>(this._resources.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceHolder getHolder(String uri) {
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            return this._resources.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String uri) {
        ResourceHolder holder;
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            holder = this._resources.get(uri);
            if (holder == null) {
                holder = new ResourceHolder(this, this.newResource(uri));
                this._resources.put(uri, holder);
            }
        }
        return holder.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String uri) {
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            return this._resources.containsKey(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T resource) {
        ResourceHolder holder = null;
        Map<String, ResourceHolder> map = this._resources;
        synchronized (map) {
            holder = this._resources.get(((AbstractResource)resource).getUri());
        }
        if (holder != null) {
            this.put(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(ResourceHolder holder) {
        block12: {
            try {
                int holds = holder._lock.getHoldCount();
                if (holds != 1) break block12;
                Object resource = holder.getResource();
                long time = ((AbstractResource)resource).nextTimeout();
                Object object = this._queue;
                synchronized (object) {
                    if (time > 0L) {
                        if (time < System.currentTimeMillis()) {
                            time = System.currentTimeMillis() + 100L;
                        }
                        this._queue.offer(holder, time);
                    } else {
                        this._queue.remove(holder);
                    }
                    this._queue.notifyAll();
                }
                if (!((AbstractResource)resource).isDone()) break block12;
                object = this._resources;
                synchronized (object) {
                    this._resources.remove(((AbstractResource)resource).getUri());
                    this._log.debug("Remove {} resource {}", (Object)resource.getClass().getSimpleName(), resource);
                }
                this.removeResource(resource);
            }
            finally {
                holder.unlock();
            }
        }
    }

    protected abstract T newResource(String var1);

    protected void removeResource(T resource) {
    }

    class Scheduler
    implements Runnable {
        Scheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractResourceManager.this._scheduler = Thread.currentThread();
            AbstractResourceManager.this._scheduler.setName(((Object)((Object)AbstractResourceManager.this)).getClass().getSimpleName() + " - scheduler");
            try {
                do {
                    try {
                        long timeout;
                        ResourceHolder holder = null;
                        PriorityQueue priorityQueue = AbstractResourceManager.this._queue;
                        synchronized (priorityQueue) {
                            holder = (ResourceHolder)AbstractResourceManager.this._queue.peek();
                            long l = timeout = holder != null ? holder.getValue() - System.currentTimeMillis() : Long.MAX_VALUE;
                            if (AbstractResourceManager.this._log.isDebugEnabled() && timeout >= 0L && holder != null) {
                                AbstractResourceManager.this._log.debug("next timeout in {} seconds for node {}", (Object)(timeout / 1000L), (Object)holder);
                            }
                            if (timeout > 0L) {
                                AbstractResourceManager.this._queue.wait(timeout);
                            } else {
                                AbstractResourceManager.this._queue.poll();
                            }
                        }
                        if (timeout > 0L) continue;
                        holder.run();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        AbstractResourceManager.this._log.warn("exception in scheduler", t);
                    }
                } while (AbstractResourceManager.this.isStarted());
            }
            finally {
                AbstractResourceManager.this._scheduler = null;
                String exit = Thread.currentThread().getName() + " exited";
                if (AbstractResourceManager.this.isStarted()) {
                    AbstractResourceManager.this._log.warn(exit);
                } else {
                    AbstractResourceManager.this._log.debug(exit);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceHolder
    extends PriorityQueue.Node
    implements Runnable {
        private T _resource;
        private ReentrantLock _lock;
        final /* synthetic */ AbstractResourceManager this$0;

        ResourceHolder(T resource) {
            this.this$0 = var1_1;
            super(Long.MAX_VALUE);
            this._lock = new ReentrantLock();
            this._resource = resource;
        }

        public T getResource() {
            return this._resource;
        }

        public T lock() {
            try {
                if (this._lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                    return this._resource;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        public int getHoldCount() {
            return this._lock.getHoldCount();
        }

        public String getOwner() {
            return this._lock.toString();
        }

        public void unlock() {
            this._lock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lock();
            if (this.this$0._log.isDebugEnabled()) {
                this.this$0._log.debug("running timeout for resource " + this._resource);
            }
            try {
                ((AbstractResource)this._resource).doTimeout(System.currentTimeMillis());
            }
            finally {
                this.this$0.put(this);
            }
        }

        public String toString() {
            return this._resource.toString();
        }
    }
}

