/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<LocalEndPoint> _connects = new LinkedBlockingQueue<LocalEndPoint>();

    public LocalConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, factories);
        this.setIdleTimeout(30000L);
    }

    public LocalConnector(Server server) {
        this(server, null, null, null, 0, new HttpConnectionFactory());
    }

    public LocalConnector(Server server, SslContextFactory sslContextFactory) {
        this(server, null, null, null, 0, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory) {
        this(server, null, null, null, 0, connectionFactory);
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        this(server, null, null, null, 0, AbstractConnectionFactory.getFactories(sslContextFactory, connectionFactory));
    }

    @Override
    public Object getTransport() {
        return this;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, 5L, TimeUnit.SECONDS);
    }

    public String getResponses(String requests, long idleFor, TimeUnit units) throws Exception {
        ByteBuffer result = this.getResponses(BufferUtil.toBuffer((String)requests, (Charset)StandardCharsets.UTF_8), idleFor, units);
        return result == null ? null : BufferUtil.toString((ByteBuffer)result, (Charset)StandardCharsets.UTF_8);
    }

    public ByteBuffer getResponses(ByteBuffer requestsBuffer) throws Exception {
        return this.getResponses(requestsBuffer, 5L, TimeUnit.SECONDS);
    }

    public ByteBuffer getResponses(ByteBuffer requestsBuffer, long idleFor, TimeUnit units) throws Exception {
        this.LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        endp.waitUntilClosedOrIdleFor(idleFor, units);
        ByteBuffer responses = endp.takeOutput();
        endp.getConnection().close();
        this.LOG.debug("responses {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)responses)});
        return responses;
    }

    public LocalEndPoint executeRequest(String rawRequest) {
        return this.executeRequest(BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.UTF_8));
    }

    private LocalEndPoint executeRequest(ByteBuffer rawRequest) {
        LocalEndPoint endp = new LocalEndPoint();
        endp.setInput(rawRequest);
        this._connects.add(endp);
        return endp;
    }

    @Override
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        this.LOG.debug("accepting {}", new Object[]{acceptorID});
        LocalEndPoint endPoint = this._connects.take();
        endPoint.onOpen();
        this.onEndPointOpened((EndPoint)endPoint);
        Connection connection = this.getDefaultConnectionFactory().newConnection(this, (EndPoint)endPoint);
        endPoint.setConnection(connection);
        connection.onOpen();
    }

    public class LocalEndPoint
    extends ByteArrayEndPoint {
        private final CountDownLatch _closed;

        public LocalEndPoint() {
            super(LocalConnector.this.getScheduler(), LocalConnector.this.getIdleTimeout());
            this._closed = new CountDownLatch(1);
            this.setGrowOutput(true);
        }

        public void addInput(String s) {
            while (this.getIn() == null || BufferUtil.hasContent((ByteBuffer)this.getIn())) {
                Thread.yield();
            }
            this.setInput(BufferUtil.toBuffer((String)s, (Charset)StandardCharsets.UTF_8));
        }

        public void close() {
            boolean wasOpen = this.isOpen();
            super.close();
            if (wasOpen) {
                this.getConnection().onClose();
                this.onClose();
            }
        }

        public void onClose() {
            LocalConnector.this.onEndPointClosed((EndPoint)this);
            super.onClose();
            this._closed.countDown();
        }

        public void shutdownOutput() {
            super.shutdownOutput();
            this.close();
        }

        public void waitUntilClosed() {
            while (this.isOpen()) {
                try {
                    if (this._closed.await(10L, TimeUnit.SECONDS)) continue;
                    break;
                }
                catch (Exception e) {
                    LocalConnector.this.LOG.warn((Throwable)e);
                }
            }
        }

        public void waitUntilClosedOrIdleFor(long idleFor, TimeUnit units) {
            Thread.yield();
            int size = this.getOutput().remaining();
            while (this.isOpen()) {
                try {
                    if (this._closed.await(idleFor, units)) continue;
                    if (size == this.getOutput().remaining()) {
                        LocalConnector.this.LOG.debug("idle for {} {}", new Object[]{idleFor, units});
                        return;
                    }
                    size = this.getOutput().remaining();
                }
                catch (Exception e) {
                    LocalConnector.this.LOG.warn((Throwable)e);
                }
            }
        }
    }
}

