/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.websocket;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.sip.SipURI;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.SipServer;
import org.cipango.server.Transport;
import org.cipango.sip.SipParser;
import org.cipango.sip.SipURIImpl;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class WebSocketConnector
extends ContainerLifeCycle
implements SipConnector {
    private static final Logger LOG = Log.getLogger(WebSocketConnector.class);
    private InetAddress _localAddr;
    private ConcurrentMap<String, WebSocketConnection> _connections;
    private int _port;
    private String _host;
    private SipURI _sipUri;
    private final SipServer _server;
    private final ByteBufferPool _bufferPool;

    public WebSocketConnector(@Name(value="sipServer") SipServer server) {
        this._server = server;
        this._bufferPool = new ArrayByteBufferPool(2048, 4096, 65536);
        this.addBean(this._server, false);
        this._connections = new ConcurrentHashMap<String, WebSocketConnection>();
        WebSocketConnection.__connector = this;
    }

    protected void doStart() throws Exception {
        if (this._port <= 0) {
            this._port = this.getTransport().getDefaultPort();
        }
        if (this._host == null) {
            try {
                this._host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
                this._host = "127.0.0.1";
            }
        }
        this._localAddr = InetAddress.getByName(this._host);
        this._sipUri = new SipURIImpl(this._host, this._port);
        this._sipUri.setTransportParam(this.getTransport().getName().toLowerCase());
        this.open();
        LOG.info("Started {}", new Object[]{this});
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public Transport getTransport() {
        return Transport.WS;
    }

    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._port = port;
    }

    public void setHost(String host) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._host = host;
    }

    public SipURI getURI() {
        return this._sipUri;
    }

    public InetAddress getAddress() {
        return this._localAddr;
    }

    public SipConnection getConnection(InetAddress addr, int port) throws IOException {
        return (SipConnection)this._connections.get(this.key(addr, port));
    }

    public WebSocketConnection addConnection(WebSocketConnection connection) {
        this._connections.put(this.key(connection), connection);
        return connection;
    }

    public void removeConnection(WebSocketConnection connection) {
        this._connections.remove(this.key(connection));
    }

    public ByteBufferPool getBufferPool() {
        return this._bufferPool;
    }

    public String toString() {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        return name + "@" + this.getHost() + ":" + this.getPort();
    }

    private String key(WebSocketConnection connection) {
        return this.key(connection.getRemoteAddress(), connection.getRemotePort());
    }

    private String key(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    public static class WebSocketConnection
    extends WebSocketAdapter
    implements SipConnection {
        private static WebSocketConnector __connector;
        private final SipMessageGenerator _sipGenerator = new SipMessageGenerator();

        public SipConnector getConnector() {
            return __connector;
        }

        public InetAddress getLocalAddress() {
            return this.getSession() == null ? null : this.getSession().getLocalAddress().getAddress();
        }

        public int getLocalPort() {
            return this.getSession() == null ? -1 : this.getSession().getLocalAddress().getPort();
        }

        public InetAddress getRemoteAddress() {
            return this.getSession() == null ? null : this.getSession().getRemoteAddress().getAddress();
        }

        public int getRemotePort() {
            return this.getSession() == null ? -1 : this.getSession().getRemoteAddress().getPort();
        }

        public void onWebSocketClose(int statusCode, String reason) {
            __connector.removeConnection(this);
            super.onWebSocketClose(statusCode, reason);
        }

        public void onWebSocketText(String data) {
            block3: {
                ByteBuffer buffer = ByteBuffer.wrap(data.getBytes(StringUtil.__UTF8_CHARSET));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received raw data on web socket connection {}:\n{}", new Object[]{this, data});
                }
                try {
                    AbstractSipConnector.MessageBuilder builder = new AbstractSipConnector.MessageBuilder(__connector._server, (SipConnection)this);
                    SipParser parser = new SipParser((SipParser.SipMessageHandler)builder);
                    parser.parseNext(buffer);
                }
                catch (Throwable t) {
                    LOG.warn(t);
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Buffer content: \r\n" + data, new Object[0]);
                }
            }
        }

        public void send(SipMessage message) throws MessageTooLongException {
            ByteBuffer buffer = null;
            int bufferSize = 2048;
            while (true) {
                buffer = __connector.getBufferPool().acquire(bufferSize, false);
                buffer.clear();
                try {
                    this._sipGenerator.generateMessage(buffer, message);
                }
                catch (MessageTooLongException e) {
                    if (bufferSize < 0x1000000) {
                        bufferSize += 2048 + message.getContentLength();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            buffer.flip();
            try {
                this.write(buffer);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            __connector.getBufferPool().release(buffer);
        }

        public void write(ByteBuffer buffer) throws IOException {
            String s = new String(buffer.array(), 0, buffer.limit(), StringUtil.__UTF8_CHARSET);
            this.getSession().getRemote().sendString(s);
        }

        public Transport getTransport() {
            if (this.getSession().isSecure()) {
                return Transport.WSS;
            }
            return Transport.WS;
        }

        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            __connector.addConnection(this);
        }

        public boolean isOpen() {
            return super.isConnected();
        }
    }
}

