/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dar;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import org.cipango.dar.DARConfiguration;
import org.cipango.dar.RouterInfo;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Default application router")
public class DefaultApplicationRouter
implements SipApplicationRouter,
Dumpable {
    private static final Logger LOG = Log.getLogger(DefaultApplicationRouter.class);
    public static final String __J_S_DAR_CONFIGURATION = "javax.servlet.sip.ar.dar.configuration";
    public static final String ROUTE_OUTGOING_REQUESTS = "org.cipango.dar.routeOutgoingRequests";
    public static final String DEFAULT_CONFIGURATION = "etc/dar.properties";
    private Map<String, RouterInfo[]> _routerInfoMap;
    private String _configuration;
    private SortedSet<String> _applicationNames = new TreeSet<String>();
    private boolean _routeOutgoingRequests = true;

    public void setConfiguration(String configuration) {
        this._configuration = configuration;
    }

    @ManagedAttribute(value="Configuration URI")
    public String getConfiguration() {
        return this._configuration;
    }

    public void setRouteOutgoingRequests(boolean b) {
        this._routeOutgoingRequests = b;
    }

    @ManagedAttribute(value="Route new outgoing requests", readonly=true)
    public boolean getRouteOutgoingRequests() {
        return this._routeOutgoingRequests;
    }

    @ManagedAttribute(value="Application names")
    public String[] getApplicationNames() {
        return this._applicationNames.toArray(new String[0]);
    }

    public void applicationDeployed(List<String> newlyDeployedApplicationNames) {
        this._applicationNames.addAll(newlyDeployedApplicationNames);
        this.init();
    }

    public void applicationUndeployed(List<String> undeployedApplicationNames) {
        this._applicationNames.removeAll(undeployedApplicationNames);
        this.init();
    }

    public void destroy() {
    }

    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo toto, Serializable stateInfo) {
        if (!this._routeOutgoingRequests && initialRequest.getRemoteAddr() == null) {
            return null;
        }
        if (this._routerInfoMap == null || this._routerInfoMap.isEmpty()) {
            if (stateInfo != null || this._applicationNames.isEmpty() || directive != SipApplicationRoutingDirective.NEW) {
                return null;
            }
            return new SipApplicationRouterInfo(this._applicationNames.first(), SipApplicationRoutingRegion.NEUTRAL_REGION, initialRequest.getFrom().getURI().toString(), null, SipRouteModifier.NO_ROUTE, (Serializable)Integer.valueOf(1));
        }
        String method = initialRequest.getMethod();
        RouterInfo[] infos = this._routerInfoMap.get(method.toUpperCase());
        if (infos == null) {
            return null;
        }
        int index = 0;
        if (stateInfo != null) {
            index = (Integer)stateInfo;
        }
        if (index >= 0 && index < infos.length) {
            RouterInfo info = infos[index];
            String identity = info.getIdentity();
            if (identity.startsWith("DAR:")) {
                try {
                    identity = initialRequest.getAddressHeader(identity.substring("DAR:".length())).getURI().toString();
                }
                catch (Exception e) {
                    LOG.debug("Failed to parse router info identity: " + info.getIdentity(), (Throwable)e);
                }
            }
            return new SipApplicationRouterInfo(info.getName(), info.getRegion(), identity, null, SipRouteModifier.NO_ROUTE, (Serializable)Integer.valueOf(index + 1));
        }
        return null;
    }

    @ManagedAttribute(value="default application when no DAR configuration has been found")
    public String getDefaultApplication() {
        if ((this._routerInfoMap == null || this._routerInfoMap.isEmpty()) && !this._applicationNames.isEmpty()) {
            return this._applicationNames.first();
        }
        return null;
    }

    public void setRouterInfos(Map<String, RouterInfo[]> infoMap) {
        this._routerInfoMap = infoMap;
    }

    public Map<String, RouterInfo[]> getRouterInfos() {
        return this._routerInfoMap;
    }

    @ManagedAttribute(value="Configuration")
    public String getConfig() {
        if (this._routerInfoMap == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String method : this._routerInfoMap.keySet()) {
            RouterInfo[] routerInfos = this._routerInfoMap.get(method);
            sb.append(method).append(": ");
            for (int i = 0; routerInfos != null && i < routerInfos.length; ++i) {
                RouterInfo routerInfo = routerInfos[i];
                sb.append('(');
                sb.append('\"').append(routerInfo.getName()).append("\", ");
                sb.append('\"').append(routerInfo.getIdentity()).append("\", ");
                sb.append('\"').append(routerInfo.getRegion().getType()).append("\", ");
                sb.append('\"').append(routerInfo.getUri()).append("\", ");
                sb.append('\"').append(routerInfo.getRouteModifier()).append("\", ");
                sb.append('\"').append(i).append('\"');
                sb.append(')');
                if (i + 1 >= routerInfos.length) continue;
                sb.append(", ");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public RouterInfo[] getRouterInfo(String key) {
        return this._routerInfoMap.get(key);
    }

    @ManagedOperation(value="Init", impact="ACTION")
    public void init() {
        if (!System.getProperty(ROUTE_OUTGOING_REQUESTS, "true").equalsIgnoreCase("true")) {
            this._routeOutgoingRequests = false;
        }
        if (this._configuration == null) {
            String configuration = System.getProperty(__J_S_DAR_CONFIGURATION);
            if (configuration != null) {
                this._configuration = configuration;
            } else if (System.getProperty("jetty.home") != null) {
                File home = new File(System.getProperty("jetty.home"));
                this._configuration = new File(home, DEFAULT_CONFIGURATION).toURI().toString();
            }
            if (this._configuration == null) {
                this._configuration = DEFAULT_CONFIGURATION;
            }
        }
        try {
            DARConfiguration config = new DARConfiguration(new URI(this._configuration));
            config.configure(this);
        }
        catch (Exception e) {
            LOG.debug("DAR configuration error: " + e, new Object[0]);
        }
        if ((this._routerInfoMap == null || this._routerInfoMap.isEmpty()) && !this._applicationNames.isEmpty()) {
            LOG.info("No DAR configuration. Using application: " + this._applicationNames.first(), new Object[0]);
        }
    }

    public void init(Properties properties) {
        this.init();
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append("DefaultApplicationRouter ");
        if (this._routerInfoMap == null || this._routerInfoMap.isEmpty()) {
            if (!this._applicationNames.isEmpty()) {
                out.append("default application: ").append(this.getDefaultApplication());
            } else {
                out.append("No applications");
            }
        } else {
            out.append("\n");
            ArrayList<DumpableMethod> l = new ArrayList<DumpableMethod>();
            Iterator<String> it = this._routerInfoMap.keySet().iterator();
            while (it.hasNext()) {
                l.add(new DumpableMethod(it.next()));
            }
            ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{l});
        }
    }

    public class DumpableMethod
    implements Dumpable {
        private String _method;

        public DumpableMethod(String method) {
            this._method = method;
        }

        public String dump() {
            return ContainerLifeCycle.dump((Dumpable)this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            out.append(this._method).append("\n");
            ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList((Object[])DefaultApplicationRouter.this._routerInfoMap.get(this._method))});
        }
    }
}

