/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dar;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import org.cipango.dar.DefaultApplicationRouter;
import org.cipango.dar.RouterInfo;

public class DARConfiguration {
    private Properties _properties;

    public DARConfiguration(URI uri) throws Exception {
        URL url;
        if (!uri.isAbsolute()) {
            File file = new File(uri.toString()).getCanonicalFile();
            url = file.toURI().toURL();
        } else {
            url = uri.toURL();
        }
        this._properties = new Properties();
        InputStream is = url.openStream();
        this._properties.load(is);
        is.close();
    }

    public DARConfiguration(URL url) throws Exception {
        this._properties = new Properties();
        InputStream is = url.openStream();
        this._properties.load(is);
        is.close();
    }

    public void configure(DefaultApplicationRouter dar) throws ParseException {
        HashMap<String, RouterInfo[]> infoMap = new HashMap<String, RouterInfo[]>();
        Enumeration<Object> e = this._properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String infos = this._properties.get(key).toString().trim();
            ArrayList<RouterInfo> list = new ArrayList<RouterInfo>();
            int li = infos.indexOf(40);
            while (li >= 0) {
                int ri = infos.indexOf(41, li);
                if (ri < 0) {
                    throw new ParseException(infos, li);
                }
                String info = infos.substring(li + 1, ri);
                li = infos.indexOf(40, ri);
                InfoIterator it = new InfoIterator(info);
                String name = it.next();
                String identity = it.next();
                SipApplicationRoutingRegion region = this.valueOf(it.next());
                String uri = it.next();
                SipRouteModifier routeModifier = SipRouteModifier.valueOf((String)it.next().toUpperCase());
                String stateInfo = it.next();
                RouterInfo sri = new RouterInfo(name, identity, region, uri, routeModifier);
                list.add(sri);
            }
            infoMap.put(key, list.toArray(new RouterInfo[0]));
        }
        dar.setRouterInfos(infoMap);
    }

    public SipApplicationRoutingRegion valueOf(String region) {
        if (SipApplicationRoutingRegion.NEUTRAL_REGION.getLabel().equalsIgnoreCase(region)) {
            return SipApplicationRoutingRegion.NEUTRAL_REGION;
        }
        if (SipApplicationRoutingRegion.ORIGINATING_REGION.getLabel().equalsIgnoreCase(region)) {
            return SipApplicationRoutingRegion.ORIGINATING_REGION;
        }
        if (SipApplicationRoutingRegion.TERMINATING_REGION.getLabel().equalsIgnoreCase(region)) {
            return SipApplicationRoutingRegion.TERMINATING_REGION;
        }
        return null;
    }

    class InfoIterator
    implements Iterator<String> {
        private String _info;
        private int i;
        private String token;

        public InfoIterator(String info) {
            this._info = info;
        }

        @Override
        public boolean hasNext() {
            int ri;
            int li;
            if (this.token == null && (li = this._info.indexOf(34, this.i)) != -1 && (ri = this._info.indexOf(34, li + 1)) != -1) {
                this.token = this._info.substring(li + 1, ri);
                this.i = ri + 1;
            }
            return this.token != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String s = this.token;
                this.token = null;
                return s;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

