/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplicationKey;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipApplicationKeyAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(SipApplicationKeyAnnotation.class);

    public SipApplicationKeyAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.isAnnotationPresent(SipApplicationKey.class)) continue;
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m.getName() + " must be static");
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new IllegalStateException(m.getName() + " must be public");
            }
            if (m.getParameterTypes().length != 1) {
                throw new IllegalStateException(m.getName() + " argument must have a single argument");
            }
            if (m.getParameterTypes()[0] != SipServletRequest.class) {
                throw new IllegalStateException(m.getName() + " argument must be of type SipServletRequest");
            }
            if (m.getReturnType() != String.class) {
                throw new IllegalStateException(m.getName() + " must return a String");
            }
            ((SipAppContext)this._context.getBean(SipAppContext.class)).getSessionHandler().setSipApplicationKeyMethod(m);
        }
    }
}

