/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;
import org.cipango.annotations.Util;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class ResourceAnnotationHandler
extends org.eclipse.jetty.annotations.ResourceAnnotationHandler {
    private static final Logger LOG = Log.getLogger(ResourceAnnotationHandler.class);

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(wac);
    }

    protected SipAppContext getSipAppCtx() {
        return (SipAppContext)this._context.getBean(SipAppContext.class);
    }

    public void doHandle(Class clazz) {
        if (Util.isServletType(clazz)) {
            this.handleClass(clazz);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.handleMethod(clazz, methods[i]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.handleField(clazz, fields[i]);
            }
        }
    }

    public void handleField(Class clazz, Field field) {
        Resource resource = field.getAnnotation(Resource.class);
        if (resource != null) {
            String jndiName = this.getSipResourceJndiName(field);
            if (jndiName != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be static", new Object[0]);
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be final", new Object[0]);
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injections);
                }
                Injection injection = new Injection();
                injection.setTarget(clazz, field, field.getType());
                injection.setJndiName(jndiName);
                injections.add(injection);
            }
        } else {
            super.handleField(clazz, field);
        }
    }

    private String getSipResourceJndiName(Field field) {
        if (field.getType() == SipFactory.class) {
            LOG.info("Detect SipFactory Resource from annotation", new Object[0]);
            return "sip/" + this.getSipAppCtx().getName() + "/SipFactory";
        }
        if (field.getType() == SipSessionsUtil.class) {
            LOG.info("Detect SipSessionsUtil Resource from annotation", new Object[0]);
            return "sip/" + this.getSipAppCtx().getName() + "/SipSessionsUtil";
        }
        if (field.getType() == TimerService.class) {
            LOG.info("Detect TimerService Resource from annotation", new Object[0]);
            return "sip/" + this.getSipAppCtx().getName() + "/TimerService";
        }
        return null;
    }
}

