/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.cipango.annotations.AnnotationDecorator;
import org.cipango.annotations.SipApplicationAnnotationHandler;
import org.cipango.annotations.SipApplicationKeyAnnotationHandler;
import org.cipango.annotations.SipListenerAnnotationHandler;
import org.cipango.annotations.SipServletAnnotationHandler;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(AnnotationConfiguration.class);

    public void configure(WebAppContext context) throws Exception {
        AnnotationParser parser = new AnnotationParser();
        SipAppContext sac = (SipAppContext)context.getBean(SipAppContext.class);
        if (sac.getSpecVersion() == 10) {
            return;
        }
        sac.addDecorator((SipAppContext.Decorator)new AnnotationDecorator(context));
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsing annotations", new Object[0]);
        }
        SipApplicationAnnotationHandler sipApplicationAnnotationHandler = new SipApplicationAnnotationHandler(context);
        parser.registerHandler((AnnotationParser.Handler)sipApplicationAnnotationHandler);
        parser.registerHandler((AnnotationParser.Handler)new SipApplicationKeyAnnotationHandler(context));
        parser.registerHandler((AnnotationParser.Handler)new SipListenerAnnotationHandler(context));
        parser.registerHandler((AnnotationParser.Handler)new SipServletAnnotationHandler(context));
        this.clearAnnotationList(parser.getAnnotationHandlers());
        this.parseContainerPath(context, parser);
        this.parseWebInfLib(context, parser);
        this.parseWebInfClasses(context, parser);
        ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
        this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
        sac.getMetaData().addDiscoveredAnnotations(annotations);
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
    }

    public void parseContainerPath(final WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning container jars", new Object[0]);
        ArrayList<URI> containerUris = new ArrayList<URI>();
        for (Resource r : context.getMetaData().getContainerResources()) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationParser parser) throws Exception {
        List jars = context.getMetaData().getOrderedWebInfJars();
        if (jars == null || jars.isEmpty()) {
            jars = context.getMetaData().getWebInfJars();
        }
        for (Resource r : jars) {
            URI uri = r.getURI();
            parser.parse(uri, new ClassNameResolver(){

                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
        }
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        Resource classesDir;
        LOG.debug("Scanning classes in WEB-INF/classes", new Object[0]);
        if (context.getWebInf() != null && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
            parser.parseDir(classesDir, new ClassNameResolver(){

                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
        }
    }

    protected void clearAnnotationList(List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        if (handlers == null) {
            return;
        }
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            ((AbstractDiscoverableAnnotationHandler)h).resetList();
        }
    }

    protected void gatherAnnotations(List<DiscoveredAnnotation> annotations, List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            annotations.addAll(((AbstractDiscoverableAnnotationHandler)h).getAnnotationList());
        }
    }
}

