/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.plus.sipapp;

import java.util.EventListener;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipResourceDecorator
implements SipAppContext.Decorator,
ServletContextHandler.Decorator {
    private static final Logger LOG = Log.getLogger(SipResourceDecorator.class);
    public static final String JNDI_SIP_PREFIX = "sip/";
    public static final String JNDI_SIP_FACTORY = "SipFactory";
    public static final String JNDI_TIMER_SERVICE = "TimerService";
    public static final String JNDI_SIP_SESSIONS_UTIL = "SipSessionsUtil";
    public static final String JNDI_SIP_FACTORY_POSTFIX = "/SipFactory";
    public static final String JNDI_TIMER_SERVICE_POSTFIX = "/TimerService";
    public static final String JNDI_SIP_SESSIONS_UTIL_POSTFIX = "/SipSessionsUtil";
    protected String _name;
    protected SipAppContext _context;

    public SipResourceDecorator(SipAppContext context) {
        this._context = context;
    }

    public void bindSipResources() throws Exception {
        Context sipCtx;
        Context compCtx;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this._context.getWebAppContext().getClassLoader());
        InitialContext context = new InitialContext();
        try {
            compCtx = (Context)context.lookup("java:comp/env");
        }
        catch (NameNotFoundException e) {
            compCtx = ((Context)context.lookup("java:comp")).createSubcontext("env");
        }
        try {
            sipCtx = (Context)compCtx.lookup("sip");
        }
        catch (NameNotFoundException e) {
            sipCtx = compCtx.createSubcontext("sip");
        }
        if (!"/".equals(this._name) && !"".equals(this._name)) {
            sipCtx.createSubcontext(this._name);
            compCtx.bind(JNDI_SIP_PREFIX + this._name + JNDI_SIP_FACTORY_POSTFIX, (Object)this._context.getSipFactory());
            compCtx.bind(JNDI_SIP_PREFIX + this._name + JNDI_TIMER_SERVICE_POSTFIX, (Object)this._context.getTimerService());
            compCtx.bind(JNDI_SIP_PREFIX + this._name + JNDI_SIP_SESSIONS_UTIL_POSTFIX, (Object)this._context.getSipSessionsUtil());
        } else {
            compCtx.bind(JNDI_SIP_PREFIX + JNDI_SIP_FACTORY_POSTFIX.substring(1), (Object)this._context.getSipFactory());
            compCtx.bind(JNDI_SIP_PREFIX + JNDI_TIMER_SERVICE_POSTFIX.substring(1), (Object)this._context.getTimerService());
            compCtx.bind(JNDI_SIP_PREFIX + JNDI_SIP_SESSIONS_UTIL_POSTFIX.substring(1), (Object)this._context.getSipSessionsUtil());
        }
        LOG.debug("Bind SIP Resources on app " + this._name, new Object[0]);
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    protected void init() {
        try {
            String name = this._context.getName();
            if (name == null || "".equals(name.trim())) {
                name = this._context.getDefaultName();
            }
            if (this._name == null || !this._name.endsWith(name)) {
                this._name = name;
                this.bindSipResources();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to bind SIP resources", (Throwable)e);
        }
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        this.init();
        return servlet;
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        this.init();
        return listener;
    }

    public void decorateServletHolder(SipServletHolder servlet) throws ServletException {
        this.init();
    }

    public void destroyServletInstance(Servlet s) {
    }

    public void destroyListenerInstance(EventListener f) {
    }

    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        return null;
    }

    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
    }

    public void decorateServletHolder(ServletHolder servlet) throws ServletException {
    }

    public void destroyFilterInstance(Filter f) {
    }
}

