/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.util;

import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.api.DiameterServletAnswer;
import org.cipango.diameter.base.Accounting;
import org.cipango.diameter.ims.Zh;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Node;
import org.cipango.diameter.util.DiameterVisitor;
import org.eclipse.jetty.util.StringUtil;

public class PrettyPrinter
implements DiameterVisitor {
    private int _index;
    private StringBuilder _buffer;

    @Override
    public void visit(DiameterMessage message) {
        this._index = 0;
        this._buffer = new StringBuilder();
        this._buffer.append("[appId=").append(message.getApplicationId());
        this._buffer.append(",e2eId=").append(message.getEndToEndId());
        this._buffer.append(",hopId=").append(message.getHopByHopId()).append("] ");
        this._buffer.append(message.getCommand());
        if (message instanceof DiameterServletAnswer) {
            this._buffer.append(" / ").append(((DiameterServletAnswer)((Object)message)).getResultCode());
        }
        this._buffer.append(StringUtil.__LINE_SEPARATOR);
    }

    @Override
    public void visit(AVP<?> avp) {
        if (!(avp.getValue() instanceof AVPList)) {
            for (int i = 0; i < this._index; ++i) {
                this._buffer.append("    ");
            }
            this._buffer.append(avp.getType()).append(" = ");
            if (avp.getValue() instanceof byte[]) {
                byte[] tab = (byte[])avp.getValue();
                if (tab != null && tab.length > 5 && tab[0] == 60 && tab[1] == 63 && tab[2] == 120 && tab[3] == 109 && tab[4] == 108) {
                    this._buffer.append(new String(tab));
                } else {
                    this._buffer.append(tab);
                }
            } else {
                this._buffer.append(avp.getValue());
            }
            this._buffer.append(StringUtil.__LINE_SEPARATOR);
        }
    }

    @Override
    public void visitEnter(AVP<AVPList> avp) {
        this._buffer.append(avp.getType() + " = ");
        this._buffer.append(StringUtil.__LINE_SEPARATOR);
        ++this._index;
    }

    @Override
    public void visitLeave(AVP<AVPList> avp) {
        --this._index;
    }

    public String toString() {
        return this._buffer.toString();
    }

    public static void main(String[] args) {
        DiameterRequest message = new DiameterRequest(new Node(), Accounting.ACR, 3, "foo");
        message.getAVPs().add(Zh.ZH_APPLICATION_ID.getAVP());
        PrettyPrinter pp = new PrettyPrinter();
        message.accept(pp);
        System.out.println(pp);
    }
}

