/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.util;

public class AAAUri {
    private String _fqdn;
    private int _port;

    public AAAUri(String fqdn, int port) {
        this._fqdn = fqdn != null && fqdn.contains(":") && !fqdn.contains("[") ? "[" + fqdn + "]" : fqdn;
        this._port = port;
    }

    public AAAUri(String fqdn, String sPort) {
        this(fqdn, Integer.parseInt(sPort));
    }

    public AAAUri(String uri) {
        if (!uri.startsWith("aaa://")) {
            throw new IllegalArgumentException("not AAA URI");
        }
        int iport = -1;
        if (uri.charAt(6) == '[') {
            int i = uri.indexOf(93, 6);
            if (i < 0) {
                throw new IllegalArgumentException("Invalid IPv6 in " + uri);
            }
            iport = uri.indexOf(58, i);
        } else {
            iport = uri.indexOf(58, 6);
        }
        int iparams = uri.indexOf(59, 6);
        int efqdn = iport;
        if (efqdn < 0) {
            efqdn = iparams;
        }
        this._fqdn = efqdn < 0 ? uri.substring(6) : uri.substring(6, efqdn);
        if (iport < 0) {
            this._port = -1;
        } else {
            String sport = iparams < 0 ? uri.substring(iport + 1) : uri.substring(iport + 1, iparams);
            try {
                this._port = Integer.parseInt(sport);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid port: " + sport);
            }
        }
    }

    public String getFQDN() {
        return this._fqdn;
    }

    public int getPort() {
        return this._port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("aaa://").append(this._fqdn);
        if (this._port != -1) {
            sb.append(':').append(this._port);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AAAUri)) {
            return false;
        }
        AAAUri uri = (AAAUri)o;
        return this._fqdn.equals(uri.getFQDN()) && this._port == uri.getPort();
    }

    public static void main(String[] args) {
        String s = "aaa://host.example.com:1234";
        AAAUri uri = new AAAUri(s);
        System.out.println(uri.getFQDN());
        System.out.println(uri.getPort());
    }
}

