/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Node;
import org.cipango.diameter.node.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.statistic.CounterStatistic;

@ManagedObject(value="Session manager")
public class SessionManager {
    private long _startTimestamp = System.currentTimeMillis() / 1000L & 0xFFFFFFFFL;
    private long _id;
    private Node _node;
    private Map<String, Session> _sessions = new HashMap<String, Session>();
    private CounterStatistic _sessionsCounter = new CounterStatistic();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(DiameterRequest request) {
        Session diameterSession = new Session(request.getApplicationSession(), request.getSessionId(), request.getContext());
        Map<String, Session> map = this._sessions;
        synchronized (map) {
            this._sessions.put(diameterSession.getId(), diameterSession);
            if (this._node.isStatsOn()) {
                this._sessionsCounter.increment();
            }
        }
        diameterSession.setNode(this._node);
        return diameterSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session get(String id) {
        Map<String, Session> map = this._sessions;
        synchronized (map) {
            return this._sessions.get(id);
        }
    }

    public SessionManager.ApplicationSessionScope openScope(SipApplicationSession session) {
        SessionManager.AppSessionIf appSession = (SessionManager.AppSessionIf)session;
        if (appSession != null && appSession.getAppSession().getContext() != null) {
            SipAppContext context = appSession.getAppSession().getContext();
            return context.getSessionHandler().getSessionManager().openScope(appSession.getAppSession());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session) {
        Map<String, Session> map = this._sessions;
        synchronized (map) {
            this._sessions.remove(session.getId());
            if (this._node.isStatsOn()) {
                this._sessionsCounter.decrement();
            }
        }
    }

    protected synchronized String newSessionId() {
        return this._node.getIdentity() + ";" + this._startTimestamp + ";" + ++this._id;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    @ManagedAttribute(value="Current sessions")
    public long getCurrentSessions() {
        return this._sessionsCounter.getCurrent();
    }

    @ManagedAttribute(value="Max sessions")
    public long getMaxSessions() {
        return this._sessionsCounter.getMax();
    }

    @ManagedAttribute(value="Total sessions")
    public long getTotalSessions() {
        return this._sessionsCounter.getTotal();
    }

    public void statsReset() {
        this._sessionsCounter.reset();
    }
}

