/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.ApplicationId;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.api.DiameterSession;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Node;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.sipapp.SipAppContext;

public class Session
implements DiameterSession {
    private Node _node;
    private ApplicationId _appId;
    private String _sessionId;
    private String _destinationRealm;
    private String _destinationHost;
    private SipApplicationSession _appSession;
    private SipAppContext _context;
    private boolean _valid = true;
    private Map<String, Object> _attributes;

    public Session(SipApplicationSession appSession, String sessionId, SipAppContext context) {
        this._sessionId = sessionId;
        this._appSession = appSession;
        this._context = context;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._appSession instanceof ApplicationSession) {
            return new ScopedAppSession((ApplicationSession)this._appSession);
        }
        return this._appSession;
    }

    public void setApplicationId(ApplicationId appId) {
        this._appId = appId;
    }

    public void setDestinationRealm(String destinationRealm) {
        this._destinationRealm = destinationRealm;
    }

    @Override
    public DiameterRequest createRequest(DiameterCommand command, boolean maintained) {
        this.checkValid();
        DiameterRequest request = new DiameterRequest(this._node, command, this._appId.getId(), this._sessionId);
        request.getAVPs().add(Common.DESTINATION_REALM, this._destinationRealm);
        if (this._destinationHost != null) {
            request.getAVPs().add(Common.DESTINATION_HOST, this._destinationHost);
        }
        request.getAVPs().add(this._appId.getAVP());
        if (maintained) {
            request.getAVPs().add(Common.AUTH_SESSION_STATE, Common.AuthSessionState.STATE_MAINTAINED);
        }
        request.setContext(this._context);
        request.setSession(this);
        return request;
    }

    @Override
    public String getId() {
        return this._sessionId;
    }

    @Override
    public ApplicationId getApplicationId() {
        return this._appId;
    }

    @Override
    public String getDestinationRealm() {
        return this._destinationRealm;
    }

    @Override
    public String getDestinationHost() {
        return this._destinationHost;
    }

    public void setDestinationHost(String destinationHost) {
        this._destinationHost = destinationHost;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    public void invalidate() {
        this.checkValid();
        this._valid = false;
        this._node.getSessionManager().removeSession(this);
    }

    private void checkValid() {
        if (!this._valid) {
            throw new IllegalStateException("Session has been invalidated");
        }
    }

    @Override
    public Object getAttribute(String name) {
        this.checkValid();
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        List<Object> names = this._attributes == null ? Collections.emptyList() : new ArrayList<String>(this._attributes.keySet());
        return Collections.enumeration(names);
    }

    @Override
    public void removeAttribute(String name) {
        this.checkValid();
        if (this._attributes == null) {
            return;
        }
        this._attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.checkValid();
        if (name == null || value == null) {
            throw new NullPointerException("name or value is null");
        }
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>(3);
        }
        this._attributes.put(name, value);
    }
}

