/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Node;
import org.cipango.diameter.node.PeerStateListener;
import org.cipango.diameter.node.TimeoutHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Peer")
public class Peer
implements Dumpable,
PeerStateListener {
    private static final Logger LOG = Log.getLogger(Peer.class);
    private Node _node;
    private String _host;
    private InetAddress _address;
    private int _port = 3868;
    private volatile State _state;
    private DiameterConnection _rConnection;
    private DiameterConnection _iConnection;
    private Map<Integer, Pending> _pendingRequests = new HashMap<Integer, Pending>();
    private Map<Integer, Pending> _waitingRequests = new HashMap<Integer, Pending>();
    private AtomicInteger _maxPendings = new AtomicInteger();
    private ArrayList<PeerStateListener> _listeners = new ArrayList();
    private long _lastAccessed;
    private volatile boolean _pending;
    private boolean _stopped;
    State CLOSED = new State("Closed"){

        @Override
        public synchronized void start() {
            Peer.this._rConnection = (Peer.this._iConnection = null);
            Peer.this.iSndConnReq();
        }

        @Override
        public synchronized void rConnCER(DiameterRequest cer) {
            Peer.this._rConnection = cer.getConnection();
            Peer.this.sendCEA(cer);
            Peer.this.setState(Peer.this.OPEN);
        }

        @Override
        public synchronized void disc(DiameterConnection connection) {
        }
    };
    State WAIT_CONN_ACK = new State("Wait-Conn-Ack"){

        @Override
        public synchronized void rcvConnAck() {
            Peer.this.sendCER();
            Peer.this.setState(Peer.this.WAIT_CEA);
        }

        @Override
        public synchronized void rcvConnNack() {
            Peer.this._iConnection = null;
            Peer.this.close();
        }

        @Override
        public synchronized void rConnCER(DiameterRequest cer) {
            Peer.this._rConnection = cer.getConnection();
            if (Peer.this.elect()) {
                Peer.this.iDisc();
                Peer.this.sendCEA(cer);
                Peer.this.setState(Peer.this.OPEN);
            } else {
                Peer.this.setState(Peer.this.WAIT_RETURNS);
            }
        }
    };
    State WAIT_CEA = new State("Wait-CEA"){

        @Override
        public synchronized void rcvCEA(DiameterAnswer cea) {
            Peer.this.setState(Peer.this.OPEN);
        }

        @Override
        public synchronized void disc(DiameterConnection connection) {
            Peer.this.iDisc();
            Peer.this.close();
        }

        @Override
        public synchronized void rConnCER(DiameterRequest cer) {
            Peer.this._rConnection = cer.getConnection();
            if (Peer.this.elect()) {
                Peer.this.iDisc();
                Peer.this.sendCEA(cer);
                Peer.this.setState(Peer.this.OPEN);
            } else {
                Peer.this.setState(Peer.this.WAIT_RETURNS);
            }
        }
    };
    State WAIT_CONN_ACK_ELECT = new State("Wait-Conn-Ack-Elect"){

        @Override
        public synchronized void disc(DiameterConnection connection) {
            Peer.this.iDisc();
            Peer.this.close();
        }

        @Override
        public synchronized void rConnCER(DiameterRequest cer) {
            Peer.this._rConnection = null;
        }

        @Override
        public synchronized void rcvConnAck() {
            Peer.this.sendCER();
            if (Peer.this.elect()) {
                Peer.this.iDisc();
                Peer.this.setState(Peer.this.OPEN);
            } else {
                Peer.this.setState(Peer.this.WAIT_RETURNS);
            }
        }

        @Override
        public synchronized void rcvConnNack() {
            Peer.this.setState(Peer.this.OPEN);
        }
    };
    State WAIT_RETURNS = new State("Wait-Returns"){

        @Override
        public synchronized void disc(DiameterConnection connection) {
            if (connection == Peer.this._iConnection) {
                Peer.this.iDisc();
                Peer.this.setState(Peer.this.OPEN);
            } else if (connection == Peer.this._rConnection) {
                Peer.this.rDisc();
                Peer.this.setState(Peer.this.WAIT_CEA);
            }
        }

        @Override
        public synchronized void rConnCER(DiameterRequest cer) {
            Peer.this._rConnection = null;
        }

        @Override
        public synchronized void rcvCEA(DiameterAnswer cea) {
            Peer.this.rDisc();
            Peer.this.setState(Peer.this.OPEN);
        }
    };
    State OPEN = new State("Open"){

        @Override
        public synchronized void disc(DiameterConnection connection) {
            if (connection == Peer.this.getConnection()) {
                Peer.this.close();
            }
        }

        @Override
        public synchronized void rcvDPR(DiameterRequest dpr) {
            try {
                DiameterAnswer dpa = dpr.createAnswer(Common.DIAMETER_SUCCESS);
                dpr.getConnection().write(dpa);
            }
            catch (IOException e) {
                LOG.warn("Unable to send DPA", new Object[0]);
            }
            Peer.this.setState(Peer.this.CLOSED);
            Peer.this._rConnection = (Peer.this._iConnection = null);
            if (dpr.get(Common.DISCONNECT_CAUSE) == Common.DisconnectCause.REBOOTING) {
                Peer.this._node.scheduleReconnect(Peer.this);
            }
        }
    };
    State CLOSING = new State("Closing"){

        @Override
        public void disc(DiameterConnection connection) {
            Peer.this.setState(Peer.this.CLOSED);
        }

        @Override
        public void rcvDPA(DiameterAnswer dpa) {
            Peer.this.setState(Peer.this.CLOSED);
        }

        @Override
        public synchronized void rcvDPR(DiameterRequest dpr) {
            try {
                DiameterAnswer dpa = dpr.createAnswer(Common.DIAMETER_SUCCESS);
                dpr.getConnection().write(dpa);
            }
            catch (IOException e) {
                LOG.warn("Unable to send DPA", new Object[0]);
            }
            Peer.this.setState(Peer.this.CLOSED);
            Peer.this._rConnection = (Peer.this._iConnection = null);
        }
    };

    public Peer() {
        this._state = this.CLOSED;
        this.addListener(this);
    }

    public Peer(String host) {
        this();
        this._host = host;
    }

    @ManagedAttribute(value="Peer host identity", readonly=true)
    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        if (this._host != null) {
            throw new IllegalArgumentException("host already set");
        }
        this._host = host;
    }

    @ManagedAttribute(value="Peer remote port", readonly=true)
    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (port == -1) {
            port = 3868;
        }
        this._port = port;
    }

    @ManagedAttribute(value="Peer host address", readonly=true)
    public InetAddress getAddress() {
        if (this._address == null) {
            try {
                this._address = InetAddress.getByName(this._host);
            }
            catch (UnknownHostException e) {
                LOG.debug("Host {} is not resolvable", new Object[]{this._host});
            }
        }
        return this._address;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public State getState() {
        return this._state;
    }

    @ManagedAttribute(value="Peer state")
    public String getStateAsString() {
        return this._state.toString();
    }

    public boolean isOpen() {
        return this._state == this.OPEN;
    }

    public boolean isClosed() {
        return this._state == this.CLOSED;
    }

    public boolean isStopped() {
        return this._stopped;
    }

    public DiameterConnection getConnection() {
        return this._iConnection != null ? this._iConnection : this._rConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DiameterRequest request) throws IOException {
        if (!this.isOpen()) {
            Map<Integer, Pending> map = this._pendingRequests;
            synchronized (map) {
                this._waitingRequests.put(request.getHopByHopId(), new Pending(request));
            }
            return;
        }
        DiameterConnection connection = this.getConnection();
        if (connection == null || !connection.isOpen()) {
            throw new IOException("connection not open");
        }
        Map<Integer, Pending> map = this._pendingRequests;
        synchronized (map) {
            this._pendingRequests.put(request.getHopByHopId(), new Pending(request));
            if (this._node.isStatsOn() && this._pendingRequests.size() > this._maxPendings.get()) {
                this._maxPendings.set(this._pendingRequests.size());
            }
        }
        connection.write(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DiameterMessage message) throws IOException {
        Peer peer = this;
        synchronized (peer) {
            this._lastAccessed = System.currentTimeMillis();
            this._pending = false;
        }
        if (message.isRequest()) {
            this.receiveRequest((DiameterRequest)message);
        } else {
            this.receiveAnswer((DiameterAnswer)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveRequest(DiameterRequest request) throws IOException {
        Peer peer = this;
        synchronized (peer) {
            switch (request.getCommand().getCode()) {
                case 280: {
                    this.receiveDWR(request);
                    return;
                }
                case 257: {
                    this.rConnCER(request);
                    return;
                }
                case 282: {
                    this._state.rcvDPR(request);
                    return;
                }
            }
        }
        this.getNode().handle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveAnswer(DiameterAnswer answer) throws IOException {
        Peer peer = this;
        synchronized (peer) {
            switch (answer.getCommand().getCode()) {
                case 257: {
                    this._state.rcvCEA(answer);
                    return;
                }
                case 280: {
                    return;
                }
                case 282: {
                    this._state.rcvDPA(answer);
                    return;
                }
            }
        }
        DiameterRequest request = null;
        Map<Integer, Pending> map = this._pendingRequests;
        synchronized (map) {
            Pending pending = this._pendingRequests.remove(answer.getHopByHopId());
            if (pending != null) {
                pending.cancel();
                request = pending.getRequest();
            }
        }
        if (request != null) {
            answer.setRequest(request);
            this.getNode().handle(answer);
        } else {
            LOG.debug("Ignore answer {} as no corresponding request found", new Object[]{answer});
        }
    }

    protected void receiveDWR(DiameterRequest dwr) {
        DiameterAnswer dwa = dwr.createAnswer(Common.DIAMETER_SUCCESS);
        try {
            dwr.getConnection().write(dwa);
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        LOG.debug(this + " " + this._state + " > " + state, new Object[0]);
        this._state = state;
        if (this._state == this.OPEN) {
            ArrayList<PeerStateListener> arrayList = this._listeners;
            synchronized (arrayList) {
                List listeners = (List)this._listeners.clone();
                for (PeerStateListener l : listeners) {
                    l.onPeerOpened(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeerOpened(Peer peer) {
        DiameterConnection connection = this.getConnection();
        if (connection == null || !connection.isOpen()) {
            LOG.warn("State is open but no open connection", new Object[0]);
            return;
        }
        Map<Integer, Pending> map = this._pendingRequests;
        synchronized (map) {
            try {
                Iterator<Pending> it = this._waitingRequests.values().iterator();
                while (it.hasNext()) {
                    Pending pending = it.next();
                    this._pendingRequests.put(pending.getRequest().getHopByHopId(), pending);
                    it.remove();
                    connection.write(pending.getRequest());
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to sent waiting requests: {}", (Throwable)e);
            }
        }
    }

    public void watchdog() {
        if (this.isOpen()) {
            if (System.currentTimeMillis() - this._lastAccessed > 2L * this._node.getTw()) {
                LOG.warn("closing peer {} since watchdog timer expires", new Object[]{this});
                this.close();
            } else if (System.currentTimeMillis() - this._lastAccessed > this._node.getTw() && !this._pending) {
                LOG.debug("sending DWR", new Object[0]);
                try {
                    DiameterRequest request = new DiameterRequest(this._node, Common.DWR, 0, null);
                    DiameterConnection connection = this.getConnection();
                    if (connection == null || !connection.isOpen()) {
                        throw new IOException("connection not open");
                    }
                    this._pending = true;
                    connection.write(request);
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return this._host + " (" + this._state + ")";
    }

    public synchronized void start() {
        if (this._host == null) {
            throw new IllegalStateException("host not set");
        }
        this._state.start();
    }

    public synchronized void rConnCER(DiameterRequest cer) {
        this._lastAccessed = System.currentTimeMillis();
        this._state.rConnCER(cer);
    }

    public synchronized void peerDisc(DiameterConnection connection) {
        this._state.disc(connection);
    }

    public synchronized void stop() {
        this._stopped = true;
        if (this._state == this.OPEN) {
            try {
                this.setState(this.CLOSING);
                DiameterRequest dpr = new DiameterRequest(this._node, Common.DPR, 0, null);
                dpr.add(Common.DISCONNECT_CAUSE, Common.DisconnectCause.REBOOTING);
                this.getConnection().write(dpr);
            }
            catch (IOException e) {
                LOG.warn("Unable to send DPR on shutdown", (Throwable)e);
            }
        } else if (this._state != this.CLOSING) {
            this.setState(this.CLOSED);
        }
    }

    protected void close() {
        if (this._rConnection != null) {
            this._rConnection.stop();
        } else if (this._iConnection != null) {
            this._iConnection.stop();
        }
        this._iConnection = null;
        this._rConnection = null;
        this.setState(this.CLOSED);
        if (!this._stopped) {
            this._node.scheduleReconnect(this);
        }
    }

    protected void timeout() {
        this.close();
    }

    protected synchronized void iSndConnReq() {
        this.setState(this.WAIT_CONN_ACK);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Peer.this._iConnection = Peer.this._node.getConnection(Peer.this);
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                    LOG.debug("Failed to connect to peer {} due to {}", new Object[]{Peer.this, e});
                }
                Peer peer = Peer.this;
                synchronized (peer) {
                    if (Peer.this._iConnection != null) {
                        Peer.this._state.rcvConnAck();
                    } else {
                        Peer.this._state.rcvConnNack();
                    }
                }
            }
        }).start();
    }

    protected boolean elect() {
        boolean won;
        String other = this.getHost();
        String local = this._node.getIdentity();
        boolean bl = won = local.compareTo(other) > 0;
        if (won) {
            LOG.debug("Won election (" + local + ">" + other + ")", new Object[0]);
        }
        return won;
    }

    protected void sendCER() {
        DiameterRequest cer = new DiameterRequest(this.getNode(), Common.CER, 0, null);
        this.getNode().addCapabilities(cer);
        try {
            this.getConnection().write(cer);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    protected void iDisc() {
        if (this._iConnection != null) {
            try {
                this._iConnection.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to disconnect " + this._iConnection + " on peer " + this + ": " + e, new Object[0]);
            }
            this._iConnection = null;
        }
    }

    protected void rDisc() {
        if (this._rConnection != null) {
            try {
                this._rConnection.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to disconnect " + this._rConnection + " on peer " + this + ": " + e, new Object[0]);
            }
            this._rConnection = null;
        }
    }

    protected void sendCEA(DiameterRequest cer) {
        DiameterAnswer cea = cer.createAnswer(Common.DIAMETER_SUCCESS);
        try {
            cea.send();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="Pendings requests")
    public int getPendings() {
        Map<Integer, Pending> map = this._pendingRequests;
        synchronized (map) {
            return this._pendingRequests.size();
        }
    }

    @ManagedAttribute(value="Maximum pending requests since last reset")
    public int getMaxPendings() {
        return this._maxPendings.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="Waiting requests")
    public int getWaitings() {
        Map<Integer, Pending> map = this._pendingRequests;
        synchronized (map) {
            return this._waitingRequests.size();
        }
    }

    public void statsReset() {
        this._maxPendings.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerStateListener l) {
        ArrayList<PeerStateListener> arrayList = this._listeners;
        synchronized (arrayList) {
            if (!this._listeners.contains(l)) {
                this._listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerStateListener l) {
        ArrayList<PeerStateListener> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.remove(l);
        }
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList("port=" + this._port, "address=" + this._address)});
    }

    class Pending
    implements Runnable {
        private DiameterRequest _request;
        private ScheduledFuture<?> _timeout;

        public Pending(DiameterRequest request) {
            this._request = request;
            this._timeout = Peer.this._node.schedule(this, Peer.this._node.getRequestTimeout());
        }

        public void cancel() {
            this._timeout.cancel(false);
        }

        public DiameterRequest getRequest() {
            return this._request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Diameter request timeout for {}", new Object[]{this._request});
            if (Peer.this._node.getHandler() instanceof TimeoutHandler) {
                ((TimeoutHandler)((Object)Peer.this._node.getHandler())).fireNoAnswerReceived(this._request, Peer.this._node.getRequestTimeout());
            }
            Map map = Peer.this._pendingRequests;
            synchronized (map) {
                Pending p = (Pending)Peer.this._pendingRequests.remove(this._request.getHopByHopId());
                if (p == null) {
                    Peer.this._waitingRequests.remove(this._request.getHopByHopId());
                }
            }
        }
    }

    private abstract class State {
        private String _name;

        public State(String name) {
            this._name = name;
        }

        public void start() {
            throw new IllegalStateException("start() in state " + this._name);
        }

        public void rConnCER(DiameterRequest cer) {
            throw new IllegalStateException("rConnCER() in state " + this._name);
        }

        public void rcvConnAck() {
            throw new IllegalStateException("rcvConnAck() in state " + this._name);
        }

        public void rcvConnNack() {
            throw new IllegalStateException("rcvConnNack() in state " + this._name);
        }

        public void rcvCEA(DiameterAnswer cea) {
            throw new IllegalStateException("rcvCEA() in state " + this._name);
        }

        public void rcvDPR(DiameterRequest dpr) {
            throw new IllegalStateException("rcvDPR() in state " + this._name);
        }

        public void rcvDPA(DiameterAnswer dpa) {
            throw new IllegalStateException("rcvDPA() in state " + this._name);
        }

        public void disc(DiameterConnection connection) {
            throw new IllegalStateException("disc() in state " + this._name);
        }

        public String toString() {
            return this._name;
        }
    }
}

