/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cipango.diameter.AVP;
import org.cipango.diameter.ApplicationId;
import org.cipango.diameter.Dictionary;
import org.cipango.diameter.app.DiameterContext;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.bio.DiameterSocketConnector;
import org.cipango.diameter.log.BasicMessageLog;
import org.cipango.diameter.node.AbstractDiameterConnector;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterConnector;
import org.cipango.diameter.node.DiameterHandler;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Peer;
import org.cipango.diameter.node.PeerStateListener;
import org.cipango.diameter.node.SessionManager;
import org.cipango.diameter.router.DefaultRouter;
import org.cipango.diameter.router.DiameterRouter;
import org.cipango.diameter.util.AAAUri;
import org.cipango.server.session.SessionManager;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Diameter node")
public class Node
extends ContainerLifeCycle
implements DiameterHandler,
Dumpable {
    private static final Logger LOG = Log.getLogger(Node.class);
    public static String[] __dictionaryClasses = new String[]{"org.cipango.diameter.base.Common", "org.cipango.diameter.base.Accounting", "org.cipango.diameter.ims.IMS", "org.cipango.diameter.ims.Cx", "org.cipango.diameter.ims.Sh", "org.cipango.diameter.ims.Zh"};
    public static final String DEFAULT_REALM = "cipango.org";
    public static final String DEFAULT_PRODUCT_NAME = "cipango";
    public static final int NEXCOM_OID = 26588;
    public static final long DEFAULT_TW = 30000L;
    public static final long DEFAULT_TC = 30000L;
    public static final long DEFAULT_REQUEST_TIMEOUT = 10000L;
    public static final long DEFAULT_REDIRECT_TIMEOUT = 1000L;
    private String _realm = "cipango.org";
    private String _identity;
    private int _vendorId = 26588;
    private String _productName = "cipango";
    private long _tw = 30000L;
    private long _tc = 30000L;
    private long _requestTimeout = 10000L;
    private DiameterConnector[] _connectors;
    private Peer[] _peers;
    private DiameterHandler _handler;
    private SessionManager _sessionManager;
    private ScheduledExecutorService _scheduler;
    private Set<ApplicationId> _supportedApplications = new HashSet<ApplicationId>();
    private DiameterRouter _router;
    protected final AtomicLong _statsStartedAt = new AtomicLong(-1L);

    public Node() {
        this.setHandler(new DiameterContext());
    }

    public Node(int port) throws IOException {
        this.setHandler(new DiameterContext());
        DiameterSocketConnector connector = new DiameterSocketConnector();
        connector.setHost(InetAddress.getLocalHost().getHostAddress());
        connector.setMessageListener(new BasicMessageLog());
        connector.setPort(port);
        this.setConnectors(new DiameterConnector[]{connector});
    }

    public void setConnectors(DiameterConnector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setNode(this);
            }
        }
        this.updateBeans(this._connectors, connectors);
        this._connectors = connectors;
    }

    @ManagedAttribute(value="Connectors", readonly=true)
    public DiameterConnector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(DiameterConnector connector) {
        this.setConnectors((DiameterConnector[])ArrayUtil.addToArray((Object[])this.getConnectors(), (Object)connector, DiameterConnector.class));
    }

    public synchronized void addPeer(Peer peer) {
        peer.setNode(this);
        this.addBean(peer);
        Peer[] peers = (Peer[])ArrayUtil.addToArray((Object[])this._peers, (Object)peer, Peer.class);
        this._peers = peers;
        if (this.isStarted()) {
            this._router.peerAdded(peer);
        }
    }

    public synchronized void removePeer(Peer peer) {
        Peer[] peers = (Peer[])ArrayUtil.removeFromArray((Object[])this._peers, (Object)peer);
        peers = (Peer[])peers.clone();
        this._peers = peers;
        peer.stop();
        if (this.isStarted()) {
            this._router.peerRemoved(peer);
        }
        this.removeBean(peer);
    }

    @ManagedAttribute(value="Peers", readonly=true)
    public Peer[] getPeers() {
        return this._peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        for (int i = 0; i < __dictionaryClasses.length; ++i) {
            Dictionary.getInstance().load(Loader.loadClass(this.getClass(), (String)__dictionaryClasses[i]));
        }
        if (this._identity == null) {
            this._identity = InetAddress.getLocalHost().getHostName();
        }
        this._sessionManager = new SessionManager();
        this._sessionManager.setNode(this);
        this.addBean(this._sessionManager);
        this._scheduler = new ScheduledThreadPoolExecutor(1);
        if (this._router == null) {
            this.setDiameterRouter(new DefaultRouter());
        }
        super.doStart();
        Node node = this;
        synchronized (node) {
            if (this._peers != null) {
                for (Peer peer : this._peers) {
                    try {
                        peer.start();
                        this._router.peerAdded(peer);
                    }
                    catch (Exception e) {
                        LOG.warn("failed to start peer: " + peer, (Throwable)e);
                    }
                }
            }
        }
        this._scheduler.scheduleAtFixedRate(new WatchdogTimeout(), 5000L, 5000L, TimeUnit.MILLISECONDS);
        LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        Node node = this;
        synchronized (node) {
            if (this._peers != null) {
                for (Peer peer : this._peers) {
                    try {
                        peer.stop();
                    }
                    catch (Exception e) {
                        LOG.warn("failed to stop peer: " + peer, (Throwable)e);
                    }
                }
                try {
                    boolean allClosed = false;
                    int iter = 20;
                    block10: while (iter-- > 0 && allClosed) {
                        allClosed = true;
                        for (Peer peer : this._peers) {
                            if (peer.isClosed()) continue;
                            allClosed = false;
                            LOG.info("Wait 50ms for " + peer + " closing", new Object[0]);
                            Thread.sleep(50L);
                            continue block10;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.ignore((Throwable)e);
                }
            }
        }
        if (this._scheduler != null) {
            this._scheduler.shutdown();
        }
        for (int i = 0; this._connectors != null && i < this._connectors.length; ++i) {
            if (!(this._connectors[i] instanceof LifeCycle)) continue;
            try {
                this._connectors[i].stop();
                continue;
            }
            catch (Exception e) {
                mex.add((Throwable)e);
            }
        }
        if (this._router != null && this._router instanceof LifeCycle) {
            ((LifeCycle)this._router).stop();
        }
        super.doStop();
        mex.ifExceptionThrow();
    }

    public void setIdentity(String identity) {
        this._identity = identity;
    }

    @ManagedAttribute(value="Identity")
    public String getIdentity() {
        return this._identity;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    @ManagedAttribute(value="Realm")
    public String getRealm() {
        return this._realm;
    }

    public int getVendorId() {
        return this._vendorId;
    }

    @ManagedAttribute(value="Product name")
    public String getProductName() {
        return this._productName;
    }

    public void setProductName(String productName) {
        this._productName = productName;
    }

    @ManagedAttribute(value="Session manager")
    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public DiameterConnection getConnection(Peer peer) throws IOException {
        return this._connectors[0].getConnection(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer getPeer(String host) {
        Node node = this;
        synchronized (node) {
            if (this._peers != null) {
                for (Peer peer : this._peers) {
                    if (!peer.getHost().equals(host)) continue;
                    return peer;
                }
            }
        }
        return null;
    }

    @ManagedAttribute(value="Diameter router", readonly=true)
    public DiameterRouter getDiameterRouter() {
        return this._router;
    }

    public void setDiameterRouter(DiameterRouter router) {
        this.updateBean(this._router, router);
        this._router = router;
    }

    public void send(DiameterRequest request) throws IOException {
        Peer peer = this._router.getRoute(request);
        if (peer == null && request.getDestinationHost() != null) {
            peer = new Peer(request.getDestinationHost());
            peer.start();
            this.addPeer(peer);
        }
        if (peer == null) {
            throw new IOException("Router found no peer and no destination host set");
        }
        peer.send(request);
    }

    public void receive(DiameterMessage message) throws IOException {
        Peer peer = message.getConnection().getPeer();
        if (peer == null) {
            if (message.getCommand() != Common.CER) {
                LOG.debug("non CER as first message: " + message.getCommand(), new Object[0]);
                message.getConnection().stop();
                return;
            }
            if (message.getCommand() == Common.CER) {
                String originHost = message.getOriginHost();
                if (originHost == null) {
                    LOG.debug("No Origin-Host in CER", new Object[0]);
                    message.getConnection().stop();
                    return;
                }
                String realm = message.getOriginRealm();
                if (realm == null) {
                    LOG.debug("No Origin-Realm in CER", new Object[0]);
                    message.getConnection().stop();
                    return;
                }
                peer = this.getPeer(originHost);
                if (peer == null) {
                    LOG.warn("Unknown peer " + originHost, new Object[0]);
                    peer = new Peer(originHost);
                    peer.setNode(this);
                    this.addPeer(peer);
                }
                message.getConnection().setPeer(peer);
                peer.rConnCER((DiameterRequest)message);
            }
        } else {
            peer.receive(message);
        }
    }

    public DiameterHandler getHandler() {
        return this._handler;
    }

    public void setHandler(DiameterHandler handler) {
        this._handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(DiameterMessage message) throws IOException {
        DiameterAnswer answer;
        String sessionId = message.getSessionId();
        if (sessionId != null) {
            message.setSession(this._sessionManager.get(sessionId));
        }
        if (message instanceof DiameterAnswer && Common.DIAMETER_REDIRECT_INDICATION.equals((answer = (DiameterAnswer)message).getResultCode())) {
            new RedirectHandler(answer).run();
            return;
        }
        try (SessionManager.ApplicationSessionScope scope = null;){
            scope = this._sessionManager.openScope(message.getApplicationSession());
            if (this._handler != null) {
                this._handler.handle(message);
            }
        }
    }

    public void addSupportedApplication(ApplicationId id) {
        this._supportedApplications.add(id);
    }

    public void addCapabilities(DiameterMessage message) {
        for (DiameterConnector connector : this._connectors) {
            message.add(Common.HOST_IP_ADDRESS, connector.getLocalAddress());
        }
        message.add(Common.VENDOR_ID, this.getVendorId());
        message.add(Common.PRODUCT_NAME, this.getProductName());
        for (ApplicationId id : this._supportedApplications) {
            if (!id.isVendorSpecific()) continue;
            for (Integer i : id.getVendors()) {
                message.add(Common.SUPPORTED_VENDOR_ID, i);
            }
        }
        for (ApplicationId id : this._supportedApplications) {
            message.getAVPs().add(id.getAVP());
        }
        message.add(Common.FIRMWARE_REVISION, 1);
    }

    public String toString() {
        return this._identity + "(" + this._supportedApplications + ")";
    }

    @ManagedAttribute(value="Tw timer in milliseconds")
    public long getTw() {
        return this._tw;
    }

    public void setTw(long tw) {
        if (tw < 6000L) {
            throw new IllegalArgumentException("Tw MUST NOT be set lower than 6 seconds");
        }
        this._tw = tw;
    }

    @ManagedAttribute(value="Tc timer in milliseconds")
    public long getTc() {
        return this._tc;
    }

    public void setTc(long tc) {
        this._tc = tc;
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long ms) {
        if (this.isRunning()) {
            return this._scheduler.schedule(runnable, ms, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public void scheduleReconnect(Peer peer) {
        this.schedule(new ConnectPeerTimeout(peer), this._tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Reset all statistics")
    public void allStatsReset() {
        this.getSessionManager().statsReset();
        for (int i = 0; this._connectors != null && i < this._connectors.length; ++i) {
            if (!(this._connectors[i] instanceof AbstractDiameterConnector)) continue;
            ((AbstractDiameterConnector)this._connectors[i]).statsReset();
        }
        Node node = this;
        synchronized (node) {
            for (int i = 0; this._peers != null && i < this._peers.length; ++i) {
                this._peers[i].statsReset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Reset statistics")
    public void statsReset() {
        this.updateNotEqual(this._statsStartedAt, -1L, System.currentTimeMillis());
        if (this.getSessionManager() != null) {
            this.getSessionManager().statsReset();
        }
        for (int i = 0; this._connectors != null && i < this._connectors.length; ++i) {
            if (!(this._connectors[i] instanceof AbstractDiameterConnector)) continue;
            ((AbstractDiameterConnector)this._connectors[i]).statsReset();
        }
        Node node = this;
        synchronized (node) {
            for (int i = 0; this._peers != null && i < this._peers.length; ++i) {
                this._peers[i].statsReset();
            }
        }
    }

    private void updateNotEqual(AtomicLong valueHolder, long compare, long value) {
        long oldValue = valueHolder.get();
        while (compare != oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    public void setStatsOn(boolean on) {
        if (on && this._statsStartedAt.get() != -1L) {
            return;
        }
        LOG.debug("Statistics on = " + on + " for " + this, new Object[0]);
        this.statsReset();
        this._statsStartedAt.set(on ? System.currentTimeMillis() : -1L);
    }

    @ManagedAttribute(value="Stats on")
    public boolean isStatsOn() {
        return this._statsStartedAt.get() != -1L;
    }

    @ManagedAttribute(value="Statistics start time")
    public long getStatsStartedAt() {
        return this._statsStartedAt.get();
    }

    public long getRequestTimeout() {
        return this._requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this._requestTimeout = requestTimeout;
    }

    public void addDictionary(String classname) throws ClassNotFoundException {
        Dictionary.getInstance().load(Loader.loadClass(this.getClass(), (String)classname));
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append("Node ").append(this._identity).append(' ').append(this.getState()).append('\n');
        ArrayList<String> l = new ArrayList<String>();
        l.add("Realm=" + this._realm);
        l.add("ProductName=" + this._productName);
        l.add("Supported applications=" + this._supportedApplications);
        this.dumpBeans(out, indent, new Collection[]{l});
    }

    class RedirectHandler
    implements Runnable,
    PeerStateListener {
        private DiameterAnswer _answer;
        private Peer _peer;
        private Iterator<AVP<String>> _it;
        private ScheduledFuture<?> _timeout;

        public RedirectHandler(DiameterAnswer answer) {
            this._answer = answer;
            this._it = this._answer.getAVPs().getAVPs(Common.REDIRECT_HOST);
            if (!this._it.hasNext()) {
                LOG.warn("Missing required REDIRECT_HOST AVP in redirect response: {}", new Object[]{this._answer});
            }
        }

        @Override
        public void run() {
            try {
                if (this._peer != null) {
                    if (this._peer.isOpen()) {
                        this._peer.send(this._answer.getRequest());
                        return;
                    }
                    this._peer.removeListener(this);
                    this._peer = null;
                }
                while (this._it.hasNext()) {
                    AAAUri uri = new AAAUri(this._it.next().getValue());
                    Peer peer = Node.this.getPeer(uri.getFQDN());
                    if (peer != null) {
                        if (!peer.isOpen()) continue;
                        LOG.debug("Redirecting request to: " + peer, new Object[0]);
                        peer.send(this._answer.getRequest());
                        return;
                    }
                    peer = new Peer(uri.getFQDN());
                    peer.setPort(uri.getPort());
                    peer.addListener(this);
                    peer.start();
                    Node.this.addPeer(peer);
                    this._peer = peer;
                    this._timeout = Node.this.schedule(this, 1000L);
                    LOG.debug("Redirecting request to new peer: " + peer, new Object[0]);
                    return;
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to redirect request", (Throwable)e);
            }
            if (Node.this.getHandler() instanceof DiameterContext) {
                ((DiameterContext)Node.this.getHandler()).fireNoAnswerReceived(this._answer.getRequest(), Node.this.getRequestTimeout());
            }
        }

        @Override
        public void onPeerOpened(Peer peer) {
            this._timeout.cancel(false);
            peer.removeListener(this);
            try {
                peer.send(this._answer.getRequest());
            }
            catch (Exception e) {
                LOG.warn("Failed to redirect request", (Throwable)e);
            }
        }
    }

    class WatchdogTimeout
    implements Runnable {
        WatchdogTimeout() {
        }

        @Override
        public void run() {
            if (Node.this._peers != null) {
                for (Peer peer : Node.this._peers) {
                    peer.watchdog();
                }
            }
        }
    }

    class ConnectPeerTimeout
    implements Runnable {
        private Peer _peer;

        public ConnectPeerTimeout(Peer peer) {
            this._peer = peer;
        }

        @Override
        public void run() {
            try {
                if (Node.this.isStarted() && !this._peer.isStopped() && !this._peer.isOpen()) {
                    LOG.debug("restarting peer: " + this._peer, new Object[0]);
                    this._peer.start();
                }
            }
            catch (Exception e) {
                LOG.warn("failed to reconnect to peer {} : {}", new Object[]{this._peer, e});
            }
        }
    }
}

