/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import java.util.Random;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.ApplicationId;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.ResultCode;
import org.cipango.diameter.api.DiameterServletRequest;
import org.cipango.diameter.api.DiameterSession;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.Node;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.sipapp.SipAppContext;

public class DiameterRequest
extends DiameterMessage
implements DiameterServletRequest {
    private static int __hopId;
    private static int __endId;
    private SipApplicationSession _appSession;
    private SipAppContext _context;
    private boolean _uac;

    private static synchronized int nextHopId() {
        return __hopId++;
    }

    private static synchronized int nextEndId() {
        return __endId++;
    }

    public DiameterRequest() {
    }

    public DiameterRequest(Node node, DiameterCommand command, int appId, String sessionId) {
        super(node, appId, command, DiameterRequest.nextEndId(), DiameterRequest.nextHopId(), sessionId);
    }

    public void setApplicationSession(SipApplicationSession appSession) {
        this._appSession = appSession;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._appSession instanceof ApplicationSession) {
            return new ScopedAppSession((ApplicationSession)this._appSession);
        }
        if (this._session != null) {
            return this._session.getApplicationSession();
        }
        return this._appSession;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public String getDestinationRealm() {
        return this.get(Common.DESTINATION_REALM);
    }

    @Override
    public String getDestinationHost() {
        return this.get(Common.DESTINATION_HOST);
    }

    @Override
    public DiameterAnswer createAnswer(ResultCode resultCode) {
        return new DiameterAnswer(this, resultCode);
    }

    @Override
    public DiameterSession getSession(boolean create) {
        if (this._session == null && create) {
            this._session = this._node.getSessionManager().createSession(this);
            if (this.isUac()) {
                this._session.setDestinationHost(this.getDestinationHost());
                this._session.setDestinationRealm(this.getDestinationRealm());
            } else {
                this._session.setDestinationHost(this.get(Common.ORIGIN_HOST));
                this._session.setDestinationRealm(this.get(Common.ORIGIN_REALM));
            }
            this._session.setApplicationId(ApplicationId.ofAVP(this));
        }
        return this._session;
    }

    @Override
    public void send() throws IOException {
        this.getNode().send(this);
    }

    public boolean isUac() {
        return this._uac;
    }

    public void setUac(boolean uac) {
        this._uac = uac;
    }

    public SipAppContext getContext() {
        return this._context;
    }

    public void setContext(SipAppContext context) {
        this._context = context;
    }

    static {
        Random random = new Random();
        __hopId = Math.abs(random.nextInt());
        __endId = (int)((System.currentTimeMillis() & 0xFFFL) << 20) + random.nextInt(0x100000);
    }
}

