/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.Type;
import org.cipango.diameter.api.DiameterServletMessage;
import org.cipango.diameter.api.DiameterSession;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.Node;
import org.cipango.diameter.node.Session;
import org.cipango.diameter.util.CommandUtil;
import org.cipango.diameter.util.DiameterVisitor;
import org.cipango.diameter.util.PrettyPrinter;
import org.cipango.diameter.util.Visitable;

public abstract class DiameterMessage
implements Visitable,
DiameterServletMessage {
    protected DiameterCommand _command;
    protected AVPList _avps;
    protected int _applicationId;
    protected int _hopByHopId;
    protected int _endToEndId;
    protected Node _node;
    protected DiameterConnection _connection;
    protected Session _session;
    private Map<String, Object> _attributes;

    public DiameterMessage() {
    }

    public DiameterMessage(Node node, int appId, DiameterCommand command, int endToEndId, int hopByHopId, String sessionId) {
        this._node = node;
        this._applicationId = appId;
        this._command = command;
        this._hopByHopId = hopByHopId;
        this._endToEndId = endToEndId;
        this._avps = new AVPList();
        if (sessionId != null) {
            this._avps.add(Common.SESSION_ID, sessionId);
        }
        this._avps.add(Common.ORIGIN_HOST, node.getIdentity());
        this._avps.add(Common.ORIGIN_REALM, node.getRealm());
    }

    public DiameterMessage(DiameterMessage message) {
        this(message._node, message._applicationId, CommandUtil.getAnswer(message._command), message._endToEndId, message._hopByHopId, message.getSessionId());
    }

    @Override
    public <T> T get(Type<T> type) {
        return this._avps.getValue(type);
    }

    @Override
    public <T> void add(Type<T> type, T value) {
        this._avps.add(type, value);
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public void setConnection(DiameterConnection connection) {
        this._connection = connection;
    }

    public DiameterConnection getConnection() {
        return this._connection;
    }

    @Override
    public int getApplicationId() {
        return this._applicationId;
    }

    public void setApplicationId(int applicationId) {
        this._applicationId = applicationId;
    }

    @Override
    public int getHopByHopId() {
        return this._hopByHopId;
    }

    public void setHopByHopId(int hopByHopId) {
        this._hopByHopId = hopByHopId;
    }

    @Override
    public int getEndToEndId() {
        return this._endToEndId;
    }

    public void setEndToEndId(int endToEndId) {
        this._endToEndId = endToEndId;
    }

    public void setCommand(DiameterCommand command) {
        this._command = command;
    }

    @Override
    public DiameterCommand getCommand() {
        return this._command;
    }

    @Override
    public String getOriginHost() {
        return this.get(Common.ORIGIN_HOST);
    }

    @Override
    public String getOriginRealm() {
        return this.get(Common.ORIGIN_REALM);
    }

    @Override
    public String getSessionId() {
        return this.get(Common.SESSION_ID);
    }

    @Override
    public int size() {
        return this._avps.size();
    }

    @Override
    public AVPList getAVPs() {
        return this._avps;
    }

    @Override
    public void setAVPList(AVPList avps) {
        this._avps = avps;
    }

    @Override
    public DiameterSession getSession() {
        return this.getSession(true);
    }

    @Override
    public abstract DiameterSession getSession(boolean var1);

    @Override
    public abstract SipApplicationSession getApplicationSession();

    public void setSession(Session session) {
        this._session = session;
    }

    @Override
    public abstract boolean isRequest();

    @Override
    public abstract void send() throws IOException;

    @Override
    public void accept(DiameterVisitor visitor) {
        visitor.visit(this);
        for (AVP avp : this._avps) {
            avp.accept(visitor);
        }
    }

    public String toString() {
        PrettyPrinter p = new PrettyPrinter();
        this.accept(p);
        return p.toString();
    }

    @Override
    public Object getAttribute(String name) {
        if (this._attributes != null) {
            return this._attributes.get(name);
        }
        return null;
    }

    @Override
    public void removeAttribute(String name) {
        if (this._attributes == null) {
            return;
        }
        this._attributes.remove(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this._attributes != null) {
            return Collections.enumeration(this._attributes.keySet());
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    @Override
    public void setAttribute(String name, Object o) {
        if (o == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        this._attributes.put(name, o);
    }
}

