/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.ApplicationId;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.api.DiameterFactory;
import org.cipango.diameter.api.DiameterServletRequest;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.Node;
import org.cipango.server.sipapp.SipAppContext;

public class DiameterFactoryImpl
implements DiameterFactory {
    private Node _node;
    private SipAppContext _appContext;

    @Override
    public DiameterServletRequest createRequest(SipApplicationSession appSession, ApplicationId id, DiameterCommand command, String destinationRealm) {
        return this.createRequest(appSession, id, command, destinationRealm, null);
    }

    @Override
    public DiameterServletRequest createRequest(SipApplicationSession appSession, ApplicationId id, DiameterCommand command, String destinationRealm, String destinationHost) {
        String sessionId = this._node.getSessionManager().newSessionId();
        DiameterRequest request = new DiameterRequest(this._node, command, id.getId(), sessionId);
        request.getAVPs().add(Common.DESTINATION_REALM, destinationRealm);
        if (destinationHost != null) {
            request.getAVPs().add(Common.DESTINATION_HOST, destinationHost);
        }
        request.getAVPs().add(id.getAVP());
        request.setApplicationSession(appSession);
        request.setContext(this._appContext);
        request.setUac(true);
        return request;
    }

    @Deprecated
    public DiameterServletRequest createRequest(ApplicationId id, DiameterCommand command, String destinationRealm) {
        return this.createRequest(id, command, destinationRealm, null);
    }

    @Deprecated
    public DiameterServletRequest createRequest(ApplicationId id, DiameterCommand command, String destinationRealm, String destinationHost) {
        return this.createRequest(null, id, command, destinationRealm, destinationHost);
    }

    public void setNode(Node node) {
        this._node = node;
    }

    protected Node getNode() {
        return this._node;
    }

    public SipAppContext getAppContext() {
        return this._appContext;
    }

    public void setAppContext(SipAppContext appContext) {
        this._appContext = appContext;
    }
}

