/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.diameter.ResultCode;
import org.cipango.diameter.api.DiameterServletAnswer;
import org.cipango.diameter.api.DiameterSession;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;

public class DiameterAnswer
extends DiameterMessage
implements DiameterServletAnswer {
    private DiameterRequest _request;
    private ResultCode _resultCode;

    public DiameterAnswer() {
    }

    public DiameterAnswer(DiameterRequest request, ResultCode resultCode) {
        super(request);
        this._request = request;
        this._resultCode = resultCode;
        this._avps.add(this._resultCode.getAVP());
    }

    public void setRequest(DiameterRequest request) {
        this._request = request;
    }

    @Override
    public DiameterRequest getRequest() {
        return this._request;
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public ResultCode getResultCode() {
        return this._resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        this._resultCode = resultCode;
    }

    @Override
    public void send() throws IOException {
        this._request.getConnection().write(this);
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._request != null) {
            return this._request.getApplicationSession();
        }
        return null;
    }

    @Override
    public DiameterSession getSession(boolean create) {
        if (this._request != null) {
            return this._request.getSession(create);
        }
        return this._session;
    }
}

