/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.node;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.cipango.diameter.log.DiameterMessageListener;
import org.cipango.diameter.node.DiameterConnector;
import org.cipango.diameter.node.Node;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Diameter connector")
public abstract class AbstractDiameterConnector
extends ContainerLifeCycle
implements DiameterConnector {
    private static final Logger LOG = Log.getLogger(AbstractDiameterConnector.class);
    private static String __localhost;
    private Node _node;
    private int _acceptors = 1;
    private int _acceptorPriorityOffset = 0;
    private String _host;
    private int _port;
    private Thread[] _acceptorThread;
    private ByteBufferPool _byteBufferPool;
    private int _messageBufferSize = 8192;
    protected AtomicLong _messagesReceived = new AtomicLong();
    protected AtomicLong _messagesSent = new AtomicLong();
    protected DiameterMessageListener _listener;

    public AbstractDiameterConnector() {
        this._port = this.getDefaultPort();
        this.setHost(__localhost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this._node == null) {
            throw new IllegalStateException("No node");
        }
        this.open();
        this._byteBufferPool = new ArrayByteBufferPool(256, 512, 65536);
        super.doStart();
        AbstractDiameterConnector abstractDiameterConnector = this;
        synchronized (abstractDiameterConnector) {
            this._acceptorThread = new Thread[this.getAcceptors()];
            for (int i = 0; i < this._acceptorThread.length; ++i) {
                this._acceptorThread[i] = new Thread(new Acceptor(i));
                this._acceptorThread[i].start();
            }
        }
        LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        this.close();
        Thread[] acceptors = null;
        AbstractDiameterConnector abstractDiameterConnector = this;
        synchronized (abstractDiameterConnector) {
            acceptors = this._acceptorThread;
            this._acceptorThread = null;
        }
        if (acceptors != null) {
            for (int i = 0; i < acceptors.length; ++i) {
                Thread thread = acceptors[i];
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    public void setMessageListener(DiameterMessageListener listener) {
        this.updateBean(this._listener, listener);
        this._listener = listener;
    }

    @ManagedAttribute(value="Diameter message listener", readonly=true)
    public DiameterMessageListener getMessageListener() {
        return this._listener;
    }

    public ByteBuffer getBuffer(int size) {
        ByteBuffer buffer = this._byteBufferPool.acquire(size, false);
        buffer.clear();
        return buffer;
    }

    public void returnBuffer(ByteBuffer buffer) {
        this._byteBufferPool.release(buffer);
    }

    public int getMessageBufferSize() {
        return this._messageBufferSize;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    @Override
    public void setHost(String host) {
        if (host == null) {
            host = __localhost;
        }
        this._host = host;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setPort(int port) {
        this._port = port;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public void setNode(Node node) {
        this._node = node;
    }

    public Node getNode() {
        return this._node;
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    protected abstract int getDefaultPort();

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + "@" + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    @ManagedAttribute(value="Messages received")
    public long getMessageReceived() {
        return this._messagesReceived.get();
    }

    @ManagedAttribute(value="Messages sent")
    public long getMessageSent() {
        return this._messagesSent.get();
    }

    public void statsReset() {
        this._messagesReceived.set(0L);
        this._messagesSent.set(0L);
    }

    static {
        try {
            __localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            __localhost = "127.0.0.1";
        }
    }

    private class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread current = Thread.currentThread();
            AbstractDiameterConnector abstractDiameterConnector = AbstractDiameterConnector.this;
            synchronized (abstractDiameterConnector) {
                if (AbstractDiameterConnector.this._acceptorThread == null) {
                    return;
                }
                ((AbstractDiameterConnector)AbstractDiameterConnector.this)._acceptorThread[this._acceptor] = current;
            }
            String name = AbstractDiameterConnector.this._acceptorThread[this._acceptor].getName();
            current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractDiameterConnector.this);
            int priority = current.getPriority();
            try {
                current.setPriority(priority - AbstractDiameterConnector.this._acceptorPriorityOffset);
                while (AbstractDiameterConnector.this.isRunning()) {
                    try {
                        AbstractDiameterConnector.this.accept(this._acceptor);
                    }
                    catch (IOException e) {
                        LOG.ignore((Throwable)e);
                    }
                    catch (Throwable t) {
                        LOG.warn(t);
                    }
                }
            }
            finally {
                current.setPriority(priority);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractDiameterConnector.this.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                AbstractDiameterConnector abstractDiameterConnector2 = AbstractDiameterConnector.this;
                synchronized (abstractDiameterConnector2) {
                    if (AbstractDiameterConnector.this._acceptorThread != null) {
                        ((AbstractDiameterConnector)AbstractDiameterConnector.this)._acceptorThread[this._acceptor] = null;
                    }
                }
            }
        }
    }
}

