/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.log;

import org.cipango.diameter.log.DiameterMessageListener;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

@ManagedObject
public class MessageListenerCollection
extends ContainerLifeCycle
implements DiameterMessageListener {
    private DiameterMessageListener[] _listeners;

    @Override
    public void messageReceived(DiameterMessage message, DiameterConnection connection) {
        for (int i = 0; this._listeners != null && i < this._listeners.length; ++i) {
            this._listeners[i].messageReceived(message, connection);
        }
    }

    @Override
    public void messageSent(DiameterMessage message, DiameterConnection connection) {
        for (int i = 0; this._listeners != null && i < this._listeners.length; ++i) {
            this._listeners[i].messageSent(message, connection);
        }
    }

    @ManagedAttribute(readonly=true)
    public DiameterMessageListener[] getMessageListeners() {
        return this._listeners;
    }

    public void setMessageListeners(DiameterMessageListener[] loggers) {
        this.updateBeans(this._listeners, loggers);
        this._listeners = loggers;
    }

    public void addMessageListener(DiameterMessageListener accessLog) {
        this.setMessageListeners((DiameterMessageListener[])ArrayUtil.addToArray((Object[])this.getMessageListeners(), (Object)accessLog, DiameterMessageListener.class));
    }

    public void removeMessageListener(DiameterMessageListener accessLog) {
        Object[] loggers = this.getMessageListeners();
        if (loggers != null && loggers.length > 0) {
            this.setMessageListeners((DiameterMessageListener[])ArrayUtil.removeFromArray((Object[])loggers, (Object)accessLog));
        }
    }
}

