/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.log;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.TimeZone;
import org.cipango.diameter.log.DiameterMessageListener;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="File message logger")
public class FileMessageLogger
extends AbstractLifeCycle
implements DiameterMessageListener {
    private static final Logger LOG = Log.getLogger(FileMessageLogger.class);
    public static final String YYYY_MM_DD = "yyyy_mm_dd";
    private OutputStream _out;
    private String _filename;
    private boolean _append = true;
    private int _retainDays = 31;
    private DateCache _logDateCache;
    private String _logDateFormat = "yyyy-MM-dd HH:mm:ss";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = TimeZone.getDefault().getID();
    private StringBuilder _buf = new StringBuilder();

    protected void doStart() throws Exception {
        this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
        this._logDateCache.setTimeZoneID(this._logTimeZone);
        this._out = this._filename != null ? new RolloverFileOutputStream(this._filename, this._append, this._retainDays) : System.out;
        super.doStart();
        LOG.info("Diameter Access log started in {}", new Object[]{this._out instanceof RolloverFileOutputStream ? ((RolloverFileOutputStream)this._out).getDatedFilename() : "stdout"});
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
            this._out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(Direction direction, DiameterMessage message, DiameterConnection connection) {
        if (!this.isStarted()) {
            return;
        }
        try {
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                this._out.write(StringUtil.__LINE_SEPARATOR.getBytes());
                this._buf.setLength(0);
                this._buf.append(this._logDateCache.format(System.currentTimeMillis()));
                if (direction == Direction.IN) {
                    this._buf.append(" IN  ");
                } else {
                    this._buf.append(" OUT ");
                }
                this._buf.append(connection.getLocalAddress());
                this._buf.append(direction == Direction.IN ? " < " : " > ");
                this._buf.append(connection.getRemoteAddress());
                this._buf.append('\n');
                this._buf.append(message);
                this._out.write(this._buf.toString().getBytes());
                this._out.flush();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to log message", (Throwable)e);
        }
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    @ManagedAttribute(value="Message log file name")
    public String getFilename() {
        return this._filename;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    @ManagedAttribute(value="Maximum day number that log files are saved")
    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int days) {
        this._retainDays = days;
    }

    @Override
    public void messageReceived(DiameterMessage message, DiameterConnection connection) {
        this.doLog(Direction.IN, message, connection);
    }

    @Override
    public void messageSent(DiameterMessage message, DiameterConnection connection) {
        this.doLog(Direction.OUT, message, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Delete log files", impact="ACTION")
    public void deleteLogFiles() throws IOException {
        if (this._filename == null) {
            return;
        }
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.close();
            File file = new File(this._filename);
            File dir = new File(file.getParent());
            String fn = file.getName();
            int s = fn.toLowerCase().indexOf(YYYY_MM_DD);
            if (s < 0) {
                file.delete();
            } else {
                String prefix = fn.substring(0, s);
                String suffix = fn.substring(s + YYYY_MM_DD.length());
                String[] logList = dir.list();
                for (int i = 0; i < logList.length; ++i) {
                    fn = logList[i];
                    if (!fn.startsWith(prefix) || fn.indexOf(suffix, prefix.length()) < 0) continue;
                    new File(dir, fn).delete();
                }
            }
            this._out = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
        }
    }

    private static enum Direction {
        IN,
        OUT;

    }
}

