/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.log;

import org.cipango.diameter.log.DiameterMessageListener;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BasicMessageLog
implements DiameterMessageListener {
    private static final Logger LOG = Log.getLogger(BasicMessageLog.class);

    protected void doLog(Direction direction, DiameterMessage message, DiameterConnection connection) {
        StringBuilder sb = new StringBuilder();
        sb.append(connection.getLocalAddress());
        sb.append(direction == Direction.IN ? " < " : " > ");
        sb.append(connection.getRemoteAddress());
        sb.append(' ');
        sb.append(message);
        LOG.info(sb.toString(), new Object[0]);
    }

    @Override
    public void messageReceived(DiameterMessage message, DiameterConnection connection) {
        this.doLog(Direction.IN, message, connection);
    }

    @Override
    public void messageSent(DiameterMessage message, DiameterConnection connection) {
        this.doLog(Direction.OUT, message, connection);
    }

    static enum Direction {
        IN,
        OUT;

    }
}

